% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper.R
\name{check_genes_missing}
\alias{check_genes_missing}
\title{Function to Check if Genes in Gene Sets Have Missing Information in Data Matrix and Direction Matrix}
\usage{
check_genes_missing(Gene_sets, Data, Direction_matrix)
}
\arguments{
\item{Gene_sets}{A list of gene sets to be analyzed, with gene set names as component names, and each component is a vector of gene entrez ID.}

\item{Data}{Data matrix of gene expressions with gene ensembl ID as row names and columns corresponding to different samples.}

\item{Direction_matrix}{Matrix containing directionality information for each gene, such as effect size, p value of summary statistics.
Each row of the matrix is for one gene, and there should be at least two columns (with the 1st column containing
gene entrez ID, and 2nd column containing directionality information).}
}
\value{
When at least one gene in the gene sets have information missing in data matrix or direction matrix, warning messages will be given, as
well as the percentages (missing number/total number) of gene sets. If less than 10 gene sets have missing information, percentages
(missing number/total number) of genes in each gene set that have missing information in data matrix and direction matrix will also be reported.
However, if more than 10 gene sets have missing information, no detailed individual gene set missing information will be reported. Also note that
if a gene set has 100\% information missing in the data or direction matrix, the name of the gene set will be notated.
}
\description{
This function is to check if genes in gene sets to be analyzed have missing information in data matrix and direction matrix.
}
\details{
Before single sample directional gene set analysis, it is necessary to check if genes in the gene sets have missing information in
data matrix and direction matrix. If not, warning messages would be given such that users can double check whether the gene set analysis results
are reliable.
}
