% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\title{Parameter Descriptions for ssdtools Functions}
\arguments{
\item{x}{The object.}

\item{object}{The object.}

\item{data}{A data frame.}

\item{pred}{A data frame of the predictions.}

\item{xlab}{A string of the x-axis label.}

\item{ylab}{A string of the x-axis label.}

\item{conc}{A numeric vector of concentrations.}

\item{percent}{A numeric vector of percentages.}

\item{ic}{A string specifying which information-theoretic criterion ('aic', 'aicc' or 'bic') to use for model averaging .}

\item{average}{A flag specifying whether to model average the estimates.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits.}

\item{level}{A number between 0 and 1 of the confidence level.}

\item{parallel}{A string specifying the type of parallel operation to be used ('no', 'snow' or 'multicore').}

\item{ncpus}{A count of the number of parallel processes to use.}

\item{...}{Unused.}

\item{q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{location}{location parameter.}

\item{llocation}{location parameter on the log scale.}

\item{scale}{scale parameter.}

\item{lscale}{scale parameter on the log scale.}

\item{lshape}{shape parameter on the log scale.}

\item{lshape1}{shape1 parameter on the log scale.}

\item{lshape2}{shape2 parameter on the log scale.}

\item{xintercept}{The x-value for the intersect}

\item{yintercept}{The y-value for the intersect.}

\item{select}{A character vector of the distributions to select.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{label}{A string of the column in data with the labels.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{color}{A string of the column in data for the color aesthetic.}

\item{size}{A number for the size of the labels.}

\item{ribbon}{A flag indicating whether to plot the confidence interval as a grey ribbon as opposed to green solid lines.}

\item{shift_x}{The value to multiply the label x values by.}

\item{hc}{A count between 1 and 99 indicating the percent hazard concentration (or NULL).}

\item{weight}{A string of the column in data with the weightings (or NULL)}

\item{dists}{A character vector of the distribution names.}

\item{computable}{A flag specifying whether to only return fits with numerically computable standard errors.}

\item{silent}{A flag indicating whether fits should fail silently.}

\item{na.rm}{A flag specifying whether to silently remove missing values or
remove them with a warning.}

\item{nsim}{A positive whole number of the number of simulations to generate.}
}
\description{
Parameter Descriptions for ssdtools Functions
}
\keyword{internal}
