% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp.R
\name{ssd_hp}
\alias{ssd_hp}
\alias{ssd_hp.fitdists}
\title{Hazard Percent}
\usage{
ssd_hp(x, ...)

\method{ssd_hp}{fitdists}(
  x,
  conc,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  average = TRUE,
  delta = 7,
  min_pboot = 0.99,
  parametric = TRUE,
  control = NULL,
  ...
)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{conc}{A numeric vector of concentrations.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits. A value of 10000 is recommended for official guidelines.}

\item{average}{A flag specifying whether to model average the estimates.}

\item{delta}{A non-negative number specifying the maximum absolute Akaike Information-theoretic Criterion difference cutoff. Distributions with an absolute difference from the best model greater than the cutoff are excluded.}

\item{min_pboot}{A number of the minimum proportion of bootstrap samples that must successfully fit
in the sense of returning a likelihood.}

\item{parametric}{A flag specifying whether to perform parametric as opposed to non-parametric bootstrapping.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}
}
\value{
A tibble of corresponding hazard percents.
}
\description{
Gets percent of species affected at specified concentration(s).
}
\details{
If \code{ci = TRUE} uses parameteric bootstrapping to get confidence intervals on the
hazard percent(s).
}
\section{Methods (by class)}{
\itemize{
\item \code{ssd_hp(fitdists)}: Hazard Percents for fitdists Object

}}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_hp(fits, conc = 1)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}}
}
