% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssd-plot.R
\name{ssd_plot}
\alias{ssd_plot}
\title{Plot Species Sensitivity Data and Distributions}
\usage{
ssd_plot(
  data,
  pred,
  left = "Conc",
  right = left,
  label = NULL,
  shape = NULL,
  color = NULL,
  size = 2.5,
  linetype = NULL,
  linecolor = NULL,
  xlab = "Concentration",
  ylab = "Species Affected",
  ci = TRUE,
  ribbon = FALSE,
  hc = 5L,
  shift_x = 3,
  bounds = c(left = 1, right = 1),
  xbreaks = waiver()
)
}
\arguments{
\item{data}{A data frame.}

\item{pred}{A data frame of the predictions.}

\item{left}{A string of the column in data with the concentrations.}

\item{right}{A string of the column in data with the right concentration values.}

\item{label}{A string of the column in data with the labels.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{color}{A string of the column in data for the color aesthetic.}

\item{size}{A number for the size of the labels.}

\item{linetype}{A string of the column in pred to use for the linetype.}

\item{linecolor}{A string of the column in pred to use for the line color.}

\item{xlab}{A string of the x-axis label.}

\item{ylab}{A string of the x-axis label.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{ribbon}{A flag indicating whether to plot the confidence interval as a grey ribbon as opposed to green solid lines.}

\item{hc}{A count between 1 and 99 indicating the percent hazard concentration (or NULL).}

\item{shift_x}{The value to multiply the label x values by.}

\item{bounds}{A named non-negative numeric vector of the left and right bounds for
uncensored missing (0 and Inf) data in terms of the orders of magnitude
relative to the extremes for non-missing values.}

\item{xbreaks}{The x-axis breaks as one of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks
\item A numeric vector of positions
}}
}
\description{
Plots species sensitivity data and distributions.
}
\examples{
ssd_plot(ssddata::ccme_boron, boron_pred, label = "Species", shape = "Group")
}
\seealso{
\code{\link[=ssd_plot_cdf]{ssd_plot_cdf()}} and \code{\link[=geom_ssdpoint]{geom_ssdpoint()}}
}
