% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunnel.R
\name{ssh_tunnel}
\alias{ssh_tunnel}
\title{Create SSH tunnel}
\usage{
ssh_tunnel(session, port = 5555, target = "rainmaker.wunderground.com:23")
}
\arguments{
\item{session}{ssh connection created with \code{\link[=ssh_connect]{ssh_connect()}}}

\item{port}{integer of local port on which to listen for incoming connections}

\item{target}{string with target host and port to connect to via ssh tunnel}
}
\description{
Opens a port on your machine and tunnel all traffic to a custom target host via the
SSH server, for example to connect with a database server behind a firewall.
}
\details{
This function blocks while the tunnel is active. Use the tunnel by connecting to
\code{localhost:5555} from a separate process. Each tunnel can only be used once and will
automatically be closed when the client disconnects. It is intended to tunnel a single
connection, not as a long running proxy server.
}
\seealso{
Other ssh: \code{\link{scp}}, \code{\link{ssh_connect}},
  \code{\link{ssh_exec}}
}
