% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sspm.R
\name{sspm}
\alias{sspm}
\alias{sspm,sspm_dataset,missing-method}
\alias{sspm,sspm_dataset,sspm_dataset-method}
\alias{sspm,sspm_dataset,list-method}
\title{Create a \code{sspm} model object}
\usage{
sspm(biomass, predictors)

\S4method{sspm}{sspm_dataset,missing}(biomass, predictors)

\S4method{sspm}{sspm_dataset,sspm_dataset}(biomass, predictors)

\S4method{sspm}{sspm_dataset,list}(biomass, predictors)
}
\arguments{
\item{biomass}{\strong{[sspm_dataset (smoothed)]} The dataset containing the
biomass variable.}

\item{predictors}{\strong{[list  OF sspm_dataset (smoothed)]} The list of predictor
datasets.}
}
\value{
An object of class  \link[=sspm-class]{sspm}.
}
\description{
Create a sspm_model object.
}
\examples{
\dontrun{
sspm_model <- sspm(biomass = biomass_smooth_w_catch,
                   predictors = predator_smooth)
}

}
