% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxForward-base.R
\name{fxForward}
\alias{fxForward}
\title{Constructing an FX-Forward}
\usage{
fxForward(domestic, foreign, time, nominal, rate, position)
}
\arguments{
\item{domestic}{character value of length one representing the base currency, i.e. the arrival currency
from which foreign fx rates are hedged. This parameter relates to the index $0$ (base currency) in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{foreign}{character value of length one representing the foreign currency, i.e. the currency on which fx rate converting \code{foreign} back to \code{domestic}
is hedged. This parameter relates to the fxForward index \code{j} (foreign currency) in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{time}{stricly positive integer value of length one representing the
time-to-maturity from \eqn{t = 0}. This parameter relates to the fxForward variable
\code{tau} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{nominal}{strictly positive numeric value of length one representing the nominal value of the contract expressed in the
\code{foreign} currency. This parameter relates to the fxForward quantity \deqn{N^{j}_{\tau}} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{rate}{positive numeric value of length one representing the forward fx rate settled in the contract from currency \code{foreign}
to currency \code{domestic}. This parameter relates to the fxForward quantity \deqn{F^{~}_{\tau}} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{position}{character value of length one. This can be either
\code{"long"} or \code{"short"} according to the definition of
\emph{long} and \emph{short} forwards in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}
}
\value{
an S3 object, instance of the class fxForward.
}
\description{
Constructor for the S3 class fxForward.
  It allows to build for an fx-forward referred under the
  name \emph{"FX-Forward"} in the FINMA technical document
  \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\examples{
# Creating new fxForwards.
fx.froward.1 <- fxForward("USD", "EUR", 1, 1000, 1.05, "long")
fx.forward.2 <- fxForward("CHF", "EUR", 10, 500, 1.1, "short")

}
\seealso{
\code{\link{summary.fxForward}}, \code{\link{print.fxForward}}.
}
