% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excelToSstModel.R
\name{keywordToTable}
\alias{keywordToTable}
\title{Extract a table from the excel template}
\usage{
keywordToTable(path, keyword, mapping.tables, keep = NULL, colNames = NULL)
}
\arguments{
\item{path}{a character value. A valid path of an input excel workbook.
The path can be relative or not.}

\item{keyword}{a character value. A valid keyword corresponding to a table.}

\item{mapping.tables}{a data.frame with following fields:
\itemize{
  \item \code{keyword}: character, list of keywords.
  \item \code{name}: character, sheet names corresponding to the keywords.
  \item \code{startRow}: integer, starting row number corresponding to position in
    the excel sheet.
  \item \code{startCol}: integer, starting column number corresponding to position in
    the excel sheet.
  \item \code{endCol}: integer, ending column number corresponding to position in
    the excel sheet.
}}

\item{keep}{integer vector, which columns should be kept or removed from
\code{startCol:endCol}.}

\item{colNames}{character vector, the colnames to be given to the parsed table.}
}
\value{
the corresponding table.
}
\description{
this function extracts tables from the excel input
workbook.
}
\seealso{
\code{\link{excelToSstModel}}.
}
