% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{sstModel-package}
\alias{sstModel-package}
\title{Implementation of the Swiss Solvency Test (SST) Standard Models.}
\description{
Framework for the implementation of solvency related computations based on
 standard models for the Swiss Solvency Test (SST), a risk-based capital standard for Swiss
 insurance companies. Allows Monte Carlo simulation of market risk, some insurance risks and
 their aggregation. Additional toolbox for preprocessing computations. Convenient shiny GUI
 combined with a parser for an input excel (.xlsx) template to simplify model configuration,
}
\section{Main Functionality the R-package}{

   The main functionality of the R-package is the construction of an \code{\link{sstModel}} object, i.e.
   an instance of the Swiss Solvency Test (SST) standard model (all parameters
   needed to create such an instance can be understood with their respective
   help pages). We can then simulate from the model with the method \code{compute}
   to obtain an \code{sstOutput} instance. Solvency figures can finally
   be computed on this last instance (like \code{\link{riskCapital}}, \code{\link{targetCapital}},
   \code{\link{marketValueMargin}}, and \code{\link{sstRatio}}).
}

\seealso{
\code{\link{sstModel}}
}
