% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalDifferentiation.R
\name{calc_gradient}
\alias{calc_gradient}
\alias{calc_hessian}
\alias{get_gradient}
\alias{get_hessian}
\alias{get_foc}
\alias{get_soc}
\title{Calculate gradient or Hessian matrix}
\usage{
calc_gradient(x, fn, h = 0.001, ...)

calc_hessian(x, fn, h = 0.001, ...)

get_gradient(stvar, ...)

get_hessian(stvar, ...)

get_foc(stvar, ...)

get_soc(stvar, ...)
}
\arguments{
\item{x}{a numeric vector specifying the point where the gradient or Hessian should be calculated.}

\item{fn}{a function that takes in argument \code{x} as the \strong{first} argument.}

\item{h}{difference used to approximate the derivatives: either a positive real number of a vector of
positive real numbers with the same length as \code{x}.}

\item{...}{other arguments passed to \code{fn} (or argument passed to \code{calc_gradient} or \code{calc_hessian}).}

\item{stvar}{object of class \code{"stvar"}}
}
\value{
Gradient functions return numerical approximation of the gradient and Hessian functions return
  numerical approximation of the Hessian. \code{get_soc} returns eigenvalues of the Hessian matrix.
}
\description{
\code{calc_gradient} or \code{calc_hessian} calculates the gradient or Hessian matrix
  of the given function at the given point using central difference numerical approximation.
  \code{get_gradient} or \code{get_hessian} calculates the gradient or Hessian matrix of the
  log-likelihood function at the parameter estimates of a class \code{'stvar'} object. \code{get_soc}
  returns eigenvalues of the Hessian matrix, and \code{get_foc} is the same as \code{get_gradient}
  but named conveniently.
}
\details{
In particular, the functions \code{get_foc} and \code{get_soc} can be used to check whether
  the found estimates denote a (local) maximum point, a saddle point, or something else. Note that
  profile log-likelihood functions can be conveniently plotted with the function \code{profile_logliks}.
}
\section{Warning}{

  No argument checks!
}

\examples{
# Create a simple function:
foo <- function(x) x^2 + x

# Calculate the gradient at x=1 and x=-0.5:
calc_gradient(x=1, fn=foo)
calc_gradient(x=-0.5, fn=foo)

# Create a more complicated function
foo <- function(x, a, b) a*x[1]^2 - b*x[2]^2

# Calculate the gradient at x=c(1, 2) with parameter values a=0.3 and b=0.1:
calc_gradient(x=c(1, 2), fn=foo, a=0.3, b=0.1)

# Create a linear Gaussian VAR p=1 model:
theta_112 <- c(0.649526, 0.066507, 0.288526, 0.021767, -0.144024, 0.897103,
 0.601786, -0.002945, 0.067224)
mod112 <- STVAR(data=gdpdef, p=1, M=1, params=theta_112)

# Calculate the gradient of the log-likelihood function about the parameter values:
get_foc(mod112)

# Calculate the eigenvalues of the Hessian matrix of the log-likelihood function
# about the parameter values:
get_soc(mod112)
}
