% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_features.R
\name{plotFeatures}
\alias{plotFeatures}
\title{Plot Selected Features}
\usage{
plotFeatures(features, sim.mat = NULL)
}
\arguments{
\item{features}{\code{list (length >= 2)}\cr
Chosen features per dataset. Each element of the list contains the features for one dataset.
The features must be given by their names (\code{character}) or indices (\code{integerish}).}

\item{sim.mat}{\code{numeric matrix}\cr
Similarity matrix which contains the similarity structure of all features based on
all datasets. The similarity values must be in the range of [0, 1] where 0 indicates
very low similarity and 1 indicates very high similarity. If the list elements of
\code{features} are integerish vectors, then the feature numbering must correspond to the
ordering of \code{sim.mat}. If the list elements of \code{features} are character
vectors, then \code{sim.mat} must be named and the names of \code{sim.mat} must correspond
to the entries in \code{features}.}
}
\value{
Object of class \code{ggplot}.
}
\description{
Creates a heatmap of the features which are selected in at least one feature set.
The sets are ordered according to average linkage hierarchical clustering based on the Manhattan
distance. If \code{sim.mat} is given, the features are ordered according to average linkage
hierarchical clustering based on \code{1 - sim.mat}. Otherwise, the features are ordered in
the same way as the feature sets.

Note that this function needs the packages \CRANpkg{ggplot2}, \CRANpkg{cowplot} and 
\CRANpkg{ggdendro} installed.
}
\examples{
feats = list(1:3, 1:4, 1:5)
mat = 0.92 ^ abs(outer(1:10, 1:10, "-"))
plotFeatures(features = feats)
plotFeatures(features = feats, sim.mat = mat)
}
