% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{autoplot.linear_stack}
\alias{autoplot.linear_stack}
\title{Plot results of a stacked ensemble model.}
\usage{
\method{autoplot}{linear_stack}(object, type = "performance", n = Inf, ...)
}
\arguments{
\item{object}{A \code{linear_stack} object outputted from \code{\link[=blend_predictions]{blend_predictions()}}
or \code{\link[=fit_members]{fit_members()}}.}

\item{type}{A single character string for plot type with values "performance",
"members", or "weights".}

\item{n}{An integer for how many members weights to plot when
\code{type = "weights"}. With multi-class data, this is the total number of weights
across classes; otherwise this is equal to the number of members.}

\item{...}{Not currently used.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot results of a stacked ensemble model.
}
\details{
A "performance" plot shows the relationship between the lasso penalty and the
resampled performance metrics. The latter includes the average number of
ensemble members. This plot can be helpful for understanding what penalty
values are reasonable.

A "members" plot shows the relationship between the average number of
ensemble members and the performance metrics. Each point is for a different
penalty value.

Neither of the "performance" or "members" plots are helpful when a single
penalty is used.

A "weights" plot shows the blending weights for the top ensemble members. The
results are for the final penalty value used to fit the ensemble.
}
