% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_ge_weight.R
\docType{class}
\name{report_ge_weight-class}
\alias{report_ge_weight-class}
\alias{report_ge_weight}
\title{Trend of wet weight in glass eel}
\description{
In trapping ladders, glass eel are seldom counted, as they are too tiny to handle and too numerous to count.
The usual operation is to weight them, or to use a bucket to measure their volume. These weights or volumes will later
need to be converted to numbers. The glass eel weight may follow a seasonal pattern. It's the case for Anguilla anguilla 
glass eel in the Bay of Biscay. Weights can be modelled using sine wave curves, or more complex gam models. 
This class has a model method to try those models, which can also be used to extact coefficients manually
to manually test more complex models.
Some plots are provided to display the coefficients stored in the database, and the model results. A parameter provided in 
the graphical interface or in the command line (slot liste) takes values "1", ">1", "tous" which mean respectively use
only individual sample of glass eels, or use "group weights" which can be more close to the real weight of glass eel
during counts as glass eel are not completely drained from their water during handling to preserve their mucus. The list choice
"tous" means that both individual and group weights are selected.
}
\section{Slots}{

\describe{
\item{\code{data}}{A \code{"data.frame"} data for report lot}

\item{\code{calcdata}}{A list containing two processed data frames, data and coe}

\item{\code{dc}}{Object of class \code{\link{ref_dc-class}}, the counting device}

\item{\code{anneedebut}}{Object of class \code{\link{ref_year-class}}. ref_year allows to choose the year of beginning}

\item{\code{anneefin}}{Object of class \code{\link{ref_year-class}}
ref_year allows to choose last year of the report}

\item{\code{coe}}{Object of class \code{\link{ref_coe-class}} class loading coefficient
of conversion between quantity (weights or volumes of glass eel) and numbers}

\item{\code{liste}}{Object of class \code{\link{ref_list-class}} ref_list referential
class choose within a list, here the choice is whether subsamples or not. Subsamples
in the stacomi database are samples with a non null value for parent sample. Migration
counts are never made on subsamples but those can be integrated to calculate mean weights.}
}}

\note{
In this class some tools are available to import glass eel measurement from
experimental fishing in the estuary. For the charge method dates for the
request are from august to august (a glass eel season)
}
\examples{
require(stacomiR)
# launching stacomi without selecting the scheme or interface
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
\dontrun{
  #create an instance of the class
  r_gew<-new("report_ge_weight")
  baseODBC<-get("baseODBC",envir=envir_stacomi)
  baseODBC[c(2,3)]<-rep("iav",2)
  assign("baseODBC",baseODBC,envir_stacomi)
  sch<-get("sch",envir=envir_stacomi)
  assign("sch","iav.",envir_stacomi)
  r_gew@liste<-charge(object=r_gew@liste,listechoice=c("=1",">1","tous"),label="")
  # here I'm using weights when number are larger than 1 ie wet weight
  # always choose a date from one year to the next eg 2010 to 2011
  # as the dates are from august to august
  r_gew<-choice_c(r_gew,
	  dc=c(6),			
	  anneedebut="2009",
	  anneefin="2015",
	  selectedvalue=">1",
	  silent=FALSE)
  r_gew<-connect(r_gew)	
  r_gew<-calcule(r_gew)
}	
# load the dataset generated by previous lines
data("r_gew")
# the calculation will fill the slot calcdata

# A ggplot showing the trend in weight
plot(r_gew, plot.type=1)
# A plot showing both the data and the trend as recorded in the database
plot(r_gew, plot.type=2)
# Same as plot.type=1 but with size according to size of the sample,
# usefull for wet weights where weight are recorded on a number of glass eel
plot(r_gew, plot.type=3)
\dontrun{
# First model with nls, see Guerault and Desaunay (1993) 
  model(r_gew,model.type="seasonal")
  model(r_gew,model.type="seasonal1")
}
}
\seealso{
Other report Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_env-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_env-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
