% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_df.R
\name{choice_c,ref_df-method}
\alias{choice_c,ref_df-method}
\title{Command line interface to choose a fishway}
\usage{
\S4method{choice_c}{ref_df}(object, df)
}
\arguments{
\item{object}{an object of class \link{ref_df-class}}

\item{df}{a character vector of df chosen}
}
\value{
An object of class ref_df with df selected
}
\description{
the choice_c method is intended to have the same behaviour as choice (which creates a
widget in the graphical interface) but from the command line.  The parameters for dF are transformed to integer as the ref_df only 
takes integer in the df slots. 
DF are third in hierarchy in the stacomi database Station>ouvrage>DF>DC>operation. This class is only used in the
report_df class.
}
\examples{
\dontrun{
win=gwindow()
group=ggroup(container=win,horizontal=FALSE)
object=new('ref_df')
object<-charge(object)
objectreport=new('report_mig_mult')
choice_c(object=object,objectreport=objectreport,dc=1)
}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
