% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-sampling-functions.R
\name{sample.sevt}
\alias{sample.sevt}
\title{Sample from a staged event tree}
\usage{
sample.sevt(object, n = 1)
}
\arguments{
\item{object}{the staged event tree object}

\item{n}{number of observations to sample}
}
\value{
A data frame containing a sample of size \code{n}
}
\description{
Generate a random sample from the distribution encoded
in a staged event tree object.
}
\details{
It samples \code{n} observations according to
the transition probabilities (\code{object$prob}) in the model.
}
\examples{
model <- naive.sevt(full(PhDArticles, lambda = 1))
sample.sevt(model, 10)
}
