% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.direction.r
\name{stamp.direction}
\alias{stamp.direction}
\title{Perform polygon directional analysis}
\usage{
stamp.direction(stmp, dir.mode = "CentroidAngle", ndir = 4, group = FALSE)
}
\arguments{
\item{stmp}{a \code{SpatialPolygonsDataFrame} object generated from the \code{stamp} function.}

\item{dir.mode}{a character item identifying which directional relations method is to be used. See \bold{Details}
for information on each individual method.}

\item{ndir}{(optional) parameter identifying the number of directions to be computed. See inidividual method
\bold{Details} for appropriate usage.}

\item{group}{(optional) a logical value identifying whether direction should be computed on groups or individual
event polygons (only used with \code{CentroidAngle} method).}
}
\value{
Appends the input \code{stamp} object with appropriate columns for the directional analysis chosen, if
 \code{dir.mode} is:
 \item{"CentroidAngle"}{A single column with centroid angle results, in degrees (North = 0 degrees). If
   \code{group=TRUE} then values are identical for all event polygons in the group.}
 \item{"ConeModel"}{\code{ndir} new columns with the area of the STAMP event in each direction,
   named appropriately (e.g., as \code{DIR45}, where 45 refers to the mid-point of that directional cone).}
 \item{"MBRModel"}{9 new columns with the area of the STAMP event in each direction,
   named appropriately as "SW","S","SE","W","SAME","E","NW","N","NE".}
 \item{"ModConeModel"}{\code{ndir} new columns  with the area of the STAMP event in each direction,
   named appropriately as, for example, "N","E","S","W" with \code{ndir=4}.}
 Note: STAMP events that are singular (i.e., only 1 polygon in the group)
 will have \code{NA}'s from directional analysis.
}
\description{
\code{stamp.direction} facilitates polygon directional analysis using a variety of methods.
}
\details{
The \code{stamp.direction} function can be used to facilitate directional analysis on output
 \code{stamp.obj} objects from function \code{stamp}. Currently, four directional analysis methods
 are available:  
 \itemize{
 \item \code{"CentroidAngle"} -- The centroid angle is simply the angle between the centroids of two polygons.
   The centroid angle method is computed on STAMP objects by first grouping all T1 polygons (by STAMP group)
   and computing their centroid. Then, the angle from each T1 group centroid, to the centroid of each STAMP event
   within the group is calculated. Centroid angles are recorded in degrees, with North having a value of 0, East
   90, and so on. \code{"CentroidAngle"} ignores the \code{ndir} parameter.
 \item \code{"ConeModel"} -- The cone model method calculates areas of STAMP event polygons within cones radiating from
   the centroid of the origin polygon.  The cone model method first computes the centroid of all T1 polygons in a STAMP grouping. It then
   computes \code{ndir} equally spaced cones radiating outward from the T1 centroid. The first cone is always
   centered on North, but there can be any number of cones. The area of each STAMP event, in each cone (specifying direction),
   is then calculated. See Peuquet and Zhang (1987) for more detailed information
 \item \code{"MBRModel"} --   The minimum bounding rectangle (MBR) method first computes the MBR for all T1 events
   in a STAMP grouping. Then the lines of four edges of the MBR are extended outwards to infinity creating
   sections for the eight cardinal directions around the MBR, along with the MBR itself. The area
   of each stamp event within each of the nine sections is then computed. See Skiadopoulos et al. (2005) for
   more detailed information. \code{"MBRModel"} ignores the \code{ndir} parameter.
 \item \code{"ModConeModel"} -- The modified cone model first computes the centroid of the T1 event that includes a stable event type.
   Then \code{ndir = 4 or 8} cones are created outward from this centroid to the minimum bounding rectangle
   of the entire grouping. As described by Robertson et al. (2007) this approach is more accomodating
   to polygon groups that are irregular in size or shape. If there is more than 1 stable event (as flagged
   by the \code{stamp.obj LEV4} column, the Voronoi segregation method defined by Robertson et al. (2007)
   is employed. The modified cone model method first computes the centroid of all T1 polygons in a STAMP grouping.
   It then computes the bounding box of ALL events in a STAMP grouping. Then, \code{ndir=4} or \code{8}
   cones are computed. In the case of \code{ndir=4}, cones radiate from the T1 centroid to the four
   corners of the bounding box. The result of the modified cone model method is that the cones
   are not equally spaced, but tailored to the individual STAMP groupings shape. See Robertson et al.
   (2007) for more detailed information.
 }
}
\references{
Robertson, C., Nelson, T., Boots, B., and Wulder, M. (2007) STAMP: Spatial-temporal analysis of moving polygons.
 \emph{Journal of Geographical Systems}, 9:207-227. \cr\cr
Peuquet, D., Zhang, C.X. (1987) An algorithm to determine the directional relationship between arbitrarily-shaped
 polygons in the plane. \emph{Pattern Recognition}, 20:65-74. \cr\cr
Skiadopoulos, S. Giannoukos, C., Sarkas, N., Vassiliadis, P., Sellis, T., and Koubarakis, M. (2005) Computing and
 managing directional relations. \emph{IEEE Transactions on Knowledge and Data Engineering}, 17:1610-1623.
}
\seealso{
stamp, stamp.distance, stamp.shape
}
\keyword{stamp}
