% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R, R/sf.R, R/raster.R, R/proxy.R
\name{st_as_stars}
\alias{st_as_stars}
\alias{st_as_stars.list}
\alias{st_as_stars.default}
\alias{st_as_stars.stars}
\alias{st_as_stars.bbox}
\alias{st_as_stars.sf}
\alias{st_as_stars.Raster}
\alias{st_as_stars.stars_proxy}
\title{convert objects into a stars object}
\usage{
st_as_stars(.x, ...)

\method{st_as_stars}{list}(.x, ..., dimensions = NULL)

\method{st_as_stars}{default}(.x = NULL, ..., raster = NULL)

\method{st_as_stars}{stars}(.x, ..., curvilinear = NULL,
  crs = st_crs(4326))

\method{st_as_stars}{bbox}(.x, ..., nx = 360, ny = 180,
  xlim = .x[c("xmin", "xmax")], ylim = .x[c("ymin", "ymax")],
  values = runif(nx * ny))

\method{st_as_stars}{sf}(.x, ...)

\method{st_as_stars}{Raster}(.x, ...)

\method{st_as_stars}{stars_proxy}(.x, ..., downsample = 0)
}
\arguments{
\item{.x}{object to convert}

\item{...}{ignored}

\item{dimensions}{object of class dimensions}

\item{raster}{character; the names of the dimensions that denote raster dimensions}

\item{curvilinear}{only for creating curvilinear grids: named length 2 list holding longitude and latitude matrices; the names of this list should correspond to raster dimensions to be replaced}

\item{crs}{object of class \code{crs} with the coordinate reference system of the values in \code{curvilinear}; see details}

\item{nx}{integer; number of cells in x direction}

\item{ny}{integer; number of cells in y direction}

\item{xlim}{length 2 numeric vector with extent in x direction}

\item{ylim}{length 2 numeric vector with extent in y direction}

\item{values}{value(s) to populate the raster values with}

\item{downsample}{integer: if larger than 0, downsample with this rate (number of pixels to skip in every row/column)}
}
\description{
convert objects into a stars object
}
\details{
if \code{curvilinear} is a \code{stars} object with longitude and latitude values, its coordinate reference system is typically not that of the latitude and longitude values.
}
