% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_schema_enrich_dimension.R
\name{enrich_dimension_import}
\alias{enrich_dimension_import}
\alias{enrich_dimension_import.star_schema}
\title{Import \code{tibble} to enrich a dimension}
\usage{
enrich_dimension_import(st, name = NULL, tb)

\method{enrich_dimension_import}{star_schema}(st, name = NULL, tb)
}
\arguments{
\item{st}{A \code{star_schema} object.}

\item{name}{A string, name of the dimension.}

\item{tb}{A \code{tibble} object.}
}
\value{
A \code{star_schema} object.
}
\description{
For a dimension of a star schema a \code{tibble} is attached. This contains
dimension attributes and new attributes. If values associated with all rows
in the dimension are included in the \code{tibble}, the dimension is enriched with
the new attributes.
}
\details{
Role dimensions cannot be directly enriched. If a role playing dimension is
enriched, the new attributes are also added to the associated role
dimensions.
}
\examples{
library(tidyr)

tb <-
  enrich_dimension_export(st_mrs_age,
                          name = "when_common",
                          attributes = c("week", "year"))

# Add new columns with meaningful data (these are not), possibly exporting
# data to a file, populating it and importing it.
tb <- tibble::add_column(tb, x = "x", y = "y", z = "z")

st <- enrich_dimension_import(st_mrs_age, name = "when_common", tb)

}
\seealso{


Other dimension enrichment functions: 
\code{\link{enrich_dimension_export}()},
\code{\link{enrich_dimension_import_test}()}
}
\concept{dimension enrichment functions}
