% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{graph.cor.test}
\alias{graph.cor.test}
\title{Test for Association / Correlation Between Paired Samples of Graphs}
\usage{
graph.cor.test(G1, G2)
}
\arguments{
\item{G1}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{G2}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}
}
\value{
\item{statistic}{ the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the estimated measure of association 'rho'.}
}
\description{
\code{graph.cor.test} tests for association between paired samples of graphs,
using Spearman's rho correlation coefficient.
}
\examples{
set.seed(1)
G1 <- G2 <- list()

p <- MASS::mvrnorm(50, mu=c(0,0), Sigma=matrix(c(1, 0.5, 0.5, 1), 2, 2))

ma <- max(p)
mi <- min(p)
p[,1] <- (p[,1] - mi)/(ma - mi)
p[,2] <- (p[,2] - mi)/(ma - mi)

for (i in 1:50) {
  G1[[i]] <- igraph::sample_gnp(50, p[i,1])
  G2[[i]] <- igraph::sample_gnp(50, p[i,2])
}
graph.cor.test(G1, G2)

}
\references{
Fujita, A., Takahashi, D. Y., Balardin, J. B., Vidal, M. C. and Sato, J. R.
(2017) Correlation between graphs with an application to brain network
analysis. _Computational Statistics & Data Analysis_ *109*, 76-92.
}
\keyword{correlation_coefficient}
