% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/sum_up.R
\name{sum_up}
\alias{sum_up}
\alias{sum_up_}
\title{Gives summary statistics (corresponds to Stata command summarize)}
\usage{
sum_up(x, ..., d = FALSE, w = NULL, i = NULL, by = NULL, digits = 3)

sum_up_(x, vars, d = FALSE, w = NULL, i = NULL, by = NULL, digits = 3)
}
\arguments{
\item{x}{a data.table}

\item{...}{Variables to include. Defaults to all non-grouping variables. See the \link[dplyr]{select} documentation.}

\item{d}{Should detailed summary statistics be printed?}

\item{w}{Weights. Default to NULL.}

\item{i}{Condition}

\item{by}{Groups within which summary statistics are printed. Default to NULL. See the \link[dplyr]{select} documentation.}

\item{digits}{Number of significant decimal digits. Default to 3}

\item{vars}{Used to work around non-standard evaluation.}
}
\description{
Gives summary statistics (corresponds to Stata command summarize)
}
\examples{
library(data.table)
N <- 100
DT <- data.table(
  id = 1:N,
  v1 = sample(5, N, TRUE),
  v2 = sample(1e6, N, TRUE)
)
sum_up(DT)
sum_up(DT, v2, d = TRUE)
sum_up(DT, starts_with("v"), by = v1)
sum_up(DT, by = v1)
}

