% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-docs.R
\docType{data}
\name{polity}
\alias{polity}
\title{Polity IV combined Polity scores}
\format{
Data frame
\describe{
\item{\code{ccode}}{Correlates of War (COW) country code.}
\item{\code{year}}{Year of the observation.}
\item{\code{polity}}{Combined Polity score.}
}
}
\source{
Marshall, Monty G., Ted Robert Gurr, and Keith Jaggers. 2017. ``Polity IV
Project: Dataset Users' Manual.'' \url{http://www.systemicpeace.org/inscr/p4manualv2016.pdf}
}
\usage{
polity
}
\description{
Polity scores reflect how democratic or autocratic countries are
from a scale of -10 (autocratic) to 10 (democratic). There are also three
special codes for foreign "interruption" (-66), anarchy (-77), and transition
periods (-88).

The data are included here for as an example for use with the missing plot.
Thus they do not contain all available Polity indicators, which are
available at the Polity project website www.systemicpeace.org.
}
\examples{
data("polity")
head("polity")
}
\keyword{datasets}
