/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Utilities;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import main.CurrentData;
import main.GenotypeValues;
import main.Par;
import main.RevGenotypeValues;
import main.RunStats;
import sample.ConsumeSingleSamples;
import sample.RecombSingleBaum;
import sample.SamplerData;

public class RecombHapPairSampler {
    private static final int nCopies = 4;
    private final Par par;
    private final RunStats runStats;
    private double edgePairsPerMarker;

    public RecombHapPairSampler(Par par, RunStats runStats) {
        if (par == null) {
            throw new NullPointerException("par");
        }
        if (runStats == null) {
            throw new NullPointerException("runStats");
        }
        this.par = par;
        this.runStats = runStats;
        this.edgePairsPerMarker = 0.0;
    }

    public List<HapPair> sample(CurrentData currentData, List<HapPair> list, boolean bl, GenotypeValues genotypeValues) {
        SamplerData samplerData = new SamplerData(this.par, currentData, list, bl, this.runStats);
        int n = 4 * currentData.nTargetSamples();
        List<HapPair> list2 = RecombHapPairSampler.synchronizedEmptyList(n);
        if (genotypeValues != null) {
            if (bl) {
                genotypeValues = new RevGenotypeValues(genotypeValues);
            }
            this.sample(samplerData, list2, genotypeValues);
        } else {
            this.sample(samplerData, list2);
        }
        return new ArrayList<HapPair>(list2);
    }

    private static List<HapPair> synchronizedEmptyList(int n) {
        ArrayList<HapPair> arrayList = new ArrayList(n);
        arrayList = Collections.synchronizedList(arrayList);
        return arrayList;
    }

    private void sample(SamplerData samplerData, List<HapPair> list, GenotypeValues genotypeValues) {
        int n;
        long l = System.nanoTime();
        int n2 = samplerData.par().nthreads();
        boolean bl = samplerData.markersAreReversed();
        Random random = new Random(this.par.seed());
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        for (n = 0; n < n2; ++n) {
            RecombSingleBaum recombSingleBaum = new RecombSingleBaum(samplerData, random.nextLong(), 4, this.par.lowmem());
            executorService.submit(new ConsumeSingleSamples(bl, recombSingleBaum, arrayBlockingQueue, list, genotypeValues));
        }
        try {
            int n3 = samplerData.nSamples();
            for (n = 0; n < n3; ++n) {
                arrayBlockingQueue.put(n);
            }
            for (n = 0; n < n2; ++n) {
                arrayBlockingQueue.put(ConsumeSingleSamples.POISON);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        this.runStats.sampleNanos(System.nanoTime() - l);
    }

    private void sample(SamplerData samplerData, List<HapPair> list) {
        int n;
        long l = System.nanoTime();
        int n2 = samplerData.par().nthreads();
        boolean bl = samplerData.markersAreReversed();
        Random random = new Random(this.par.seed());
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        for (n = 0; n < n2; ++n) {
            RecombSingleBaum recombSingleBaum = new RecombSingleBaum(samplerData, random.nextLong(), 4, this.par.lowmem());
            executorService.submit(new ConsumeSingleSamples(bl, recombSingleBaum, arrayBlockingQueue, list));
        }
        try {
            int n3 = samplerData.nSamples();
            for (n = 0; n < n3; ++n) {
                arrayBlockingQueue.put(n);
            }
            for (n = 0; n < n2; ++n) {
                arrayBlockingQueue.put(ConsumeSingleSamples.POISON);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        this.runStats.sampleNanos(System.nanoTime() - l);
    }
}

