/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;

public final class RefGL
implements GL {
    private final Samples samples;
    private final Markers markers;
    private final VcfEmission[] vea;

    public RefGL(Samples samples, VcfEmission[] vcfEmissionArray) {
        RefGL.checkData(samples, vcfEmissionArray);
        this.markers = RefGL.markers(vcfEmissionArray);
        this.samples = samples;
        this.vea = (VcfEmission[])vcfEmissionArray.clone();
    }

    private static void checkData(Samples samples, VcfEmission[] vcfEmissionArray) {
        for (int i = 0; i < vcfEmissionArray.length; ++i) {
            if (!vcfEmissionArray[i].samples().equals(samples)) {
                String string = "samples=" + samples + Const.nl + "pma[" + i + "].samples()=" + vcfEmissionArray[i].samples();
                throw new IllegalArgumentException(string);
            }
            if (vcfEmissionArray[i].isRefData()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
    }

    private static Markers markers(VcfEmission[] vcfEmissionArray) {
        Marker[] markerArray = new Marker[vcfEmissionArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = vcfEmissionArray[i].marker();
        }
        return Markers.create(markerArray);
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        int n5 = this.vea[n].allele1(n2);
        int n6 = this.vea[n].allele2(n2);
        return n3 == n5 && n4 == n6 ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n, int n2) {
        return true;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.vea[n].allele1(n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.vea[n].allele2(n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.vea[n].allele(n2);
    }

    @Override
    public int nMarkers() {
        return this.vea.length;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(": nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        for (VcfEmission vcfEmission : this.vea) {
            stringBuilder.append(Const.nl);
            stringBuilder.append(vcfEmission);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

