% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeMarkers.R
\name{codeMarkers}
\alias{codeMarkers}
\title{Code and impute markers}
\usage{
codeMarkers(
  gData,
  refAll = "minor",
  nMissGeno = 1,
  nMiss = 1,
  MAF = NULL,
  removeDuplicates = TRUE,
  keep = NULL,
  impute = TRUE,
  imputeType = c("random", "fixed", "beagle"),
  fixedValue = NULL,
  naStrings = NA,
  verbose = FALSE
)
}
\arguments{
\item{gData}{An object of class \code{gData} containing at least
\code{markers}.}

\item{refAll}{A character string indicating the reference allele used when
recoding markers.\cr
If "minor", then the recoding is done using the minor allele as reference
allele. Alternatively a single character can be supplied as a reference
allele for the whole set of SNPs, or a character vector with a reference
allele per SNP.}

\item{nMissGeno}{A numerical value between 0 and 1. Genotypes with a
fraction of missing values higher than \code{nMissGeno} will be removed. 
Genotypes with only missing values will always be removed.}

\item{nMiss}{A numerical value between 0 and 1. SNPs with a fraction of
missing values higher than \code{nMiss} will be removed. SNPs with only 
missing values will always be removed.}

\item{MAF}{A numerical value between 0 and 1. SNPs with a Minor Allele
Frequency (MAF) below this value will be removed.}

\item{removeDuplicates}{Should duplicate SNPs be removed?}

\item{keep}{A vector of SNPs that should never be removed in the whole
process.}

\item{impute}{Should imputation of missing values be done?}

\item{imputeType}{A character string indicating what kind of imputation of
values should be done.\cr
\itemize{
\item{fixed - missing values will be replaced by a given fixed value.}
\item{random - missing values will be replaced by a random value calculated
using allele frequencies per SNP.}
\item{beagle - missing values will be imputed using beagle software. Beagle
only accepts integers as map positions. If you use this option, please cite
the original papers in your publication (see references).}
}}

\item{fixedValue}{A numerical value used for replacing missing values in
case \code{inputType} is fixed.}

\item{naStrings}{A character vector of strings to be treated as NA.}

\item{verbose}{Should a summary of the performed steps be printed?}
}
\value{
A copy of the input \code{gData} object with markers replaced by
coded and imputed markers.
}
\description{
\code{codeMarkers} codes markers in a \code{gData} object and optionally
performs imputation of missing values as well.\cr
The function performs the following steps:\cr
\enumerate{
\item{replace strings in \code{naStrings} by \code{NA}.}
\item{remove genotypes with a fraction of missing values higher than
\code{nMissGeno}.}
\item{remove SNPs with a fraction of missing values higher than
\code{nMiss}.}
\item{recode SNPs to numerical values.}
\item{remove SNPs with a minor allele frequency lower than \code{MAF}.}
\item{optionally remove duplicate SNPs.}
\item{optionally impute missing values.}
\item{repeat steps 5. and 6. if missing values are imputed.}
}
}
\examples{
## Create markers
markers <- matrix(c(
"AA",   "AB",   "AA",   "BB",   "BA",   "AB",   "AA",   "AA",   NA,  "AA",
"AA",   "AA",   "BB",   "BB",   "AA",   "AA",   "BB",   "AA",   NA,  "AA",
"AA",   "BA",   "AB",   "BB",   "AB",   "AB",   "AA",   "BB",   NA,  "AA",
"AA",   "AA",   "BB",   "BB",   "AA",   "AA",   "AA",   "AA",   NA,  "AA",
"AA",   "AA",   "BB",   "BB",   "AA",   "BB",   "BB",   "BB",  "AB", "AA",
"AA",   "AA",   "BB",   "BB",   "AA",    NA,    "BB",   "AA",   NA,  "AA",
"AB",   "AB",   "BB",   "BB",   "BB",   "AA",   "BB",   "BB",   NA,  "AB",
"AA",   "AA",    NA,    "BB",    NA,    "AA",   "AA",   "AA",  "AA", "AA",
"AA",    NA,     NA,    "BB",   "BB",   "BB",   "BB",   "BB",  "AA", "AA",
"AA",    NA,    "AA",   "BB",   "BB",   "BB",   "AA",   "AA",   NA,  "AA"),
ncol = 10, byrow = TRUE, dimnames = list(paste0("IND", 1:10),
paste0("SNP", 1:10)))

## create object of class 'gData'.
gData <- createGData(geno = markers)

## Code markers by minor allele, no imputation.
gDataCoded1 <- codeMarkers(gData = gData, impute = FALSE)

## Code markers by reference alleles, impute missings by fixed value.
gDataCoded2 <- codeMarkers(gData = gData,
                           refAll = rep(x = c("A", "B"), times =  5),
                           impute = TRUE, imputeType = "fixed",
                           fixedValue = 1)

## Code markers by minor allele, impute by random value.
gDataCoded3 <- codeMarkers(gData = gData, impute = TRUE,
                           imputeType = "random")

}
\references{
B L Browning and S R Browning (2016). Genotype imputation with
millions of reference samples. Am J Hum Genet 98:116-126.
doi:10.1016/j.ajhg.2015.11.020
}
