/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.Arrays;
import main.HapAlleleProbs;
import main.LowMemHapAlleleProbs;
import sample.ImputationData;
import sample.RefHapSegs;
import vcf.Markers;

public class LSHapBaum {
    private final ImputationData impData;
    private final boolean lowMem;
    private final int n;
    private final Markers refMarkers;
    private final float[] alleleProbs;
    private final float[][] fwdVal;
    private final float[] bwdVal;
    private final int[] fwdValueIndex2Marker;
    private final RefHapSegs refHapSegs;
    private final float[][] fwdHapProbs;
    private final float[][] bwdHapProbs;
    private int windowIndex = -9999;
    private int arrayIndex = -9999;

    public LSHapBaum(ImputationData imputationData, boolean bl) {
        this.impData = imputationData;
        this.lowMem = bl;
        this.n = imputationData.refHapPairs().nHaps();
        this.refMarkers = imputationData.refHapPairs().markers();
        this.alleleProbs = new float[this.refMarkers.sumAlleles()];
        int n = imputationData.nClusters();
        int n2 = bl ? (int)Math.ceil(Math.sqrt(1 + 8 * n) / 2.0) + 1 : n;
        this.fwdValueIndex2Marker = new int[n2];
        this.fwdVal = new float[n2][this.n];
        this.bwdVal = new float[this.n];
        this.refHapSegs = imputationData.refHapSegs();
        this.fwdHapProbs = new float[imputationData.nClusters()][];
        this.bwdHapProbs = new float[imputationData.nClusters()][];
        for (int i = 0; i < n; ++i) {
            this.fwdHapProbs[i] = new float[this.refHapSegs.nSeq(i + 1)];
            this.bwdHapProbs[i] = new float[this.refHapSegs.nSeq(i)];
        }
    }

    public HapAlleleProbs randomHapSample(int n) {
        Arrays.fill(this.alleleProbs, 0.0f);
        int n2 = this.impData.nClusters();
        this.windowIndex = 0;
        this.arrayIndex = -1;
        this.setForwardValues(0, n2, n);
        Arrays.fill(this.bwdVal, 1.0f / (float)this.n);
        this.setStateProbs(n2 - 1, this.currentIndex());
        for (int i = n2 - 2; i >= 0; --i) {
            this.setBwdValue(i, n);
            this.setStateProbs(i, this.previousIndex(n));
        }
        this.setAlleleProbs(this.alleleProbs);
        return new LowMemHapAlleleProbs(this.refMarkers, this.impData.targetSamples(), n, this.alleleProbs);
    }

    public ImputationData imputationData() {
        return this.impData;
    }

    private void setForwardValues(int n, int n2, int n3) {
        float f = 1.0f;
        for (int i = n; i < n2; ++i) {
            float f2 = this.impData.pRecomb(i);
            float f3 = 1.0f - f2;
            float f4 = this.impData.noErrProb(i);
            float f5 = this.impData.errProb(i);
            float f6 = f2 / (float)this.n;
            float f7 = f3 / f;
            int n4 = this.currentIndex();
            int n5 = this.nextIndex();
            float f8 = 0.0f;
            this.fwdValueIndex2Marker[n5] = i;
            int n6 = this.impData.targetAllele(i, n3);
            for (int j = 0; j < this.n; ++j) {
                float f9 = n6 == this.impData.refAllele(i, j) ? f4 : f5;
                this.fwdVal[n5][j] = i == 0 ? f9 : f9 * (f7 * this.fwdVal[n4][j] + f6);
                f8 += this.fwdVal[n5][j];
            }
            f = f8;
        }
    }

    private void setBwdValue(int n, int n2) {
        float f;
        int n3 = n + 1;
        float f2 = this.impData.pRecomb(n3);
        float f3 = 1.0f - f2;
        float f4 = this.impData.noErrProb(n3);
        float f5 = this.impData.errProb(n3);
        float f6 = 0.0f;
        int n4 = this.impData.targetAllele(n3, n2);
        for (int i = 0; i < this.n; ++i) {
            f = n4 == this.impData.refAllele(n3, i) ? f4 : f5;
            int n5 = i;
            this.bwdVal[n5] = this.bwdVal[n5] * f;
            f6 += this.bwdVal[i];
        }
        float f7 = f3 / f6;
        f = f2 / (float)this.n;
        for (int i = 0; i < this.n; ++i) {
            this.bwdVal[i] = f7 * this.bwdVal[i] + f;
        }
    }

    private void setStateProbs(int n, int n2) {
        Arrays.fill(this.fwdHapProbs[n], 0.0f);
        Arrays.fill(this.bwdHapProbs[n], 0.0f);
        for (int i = 0; i < this.n; ++i) {
            float f = this.fwdVal[n2][i] * this.bwdVal[i];
            float[] fArray = this.fwdHapProbs[n];
            int n3 = this.refHapSegs.seq(n + 1, i);
            fArray[n3] = fArray[n3] + f;
            float[] fArray2 = this.bwdHapProbs[n];
            int n4 = this.refHapSegs.seq(n, i);
            fArray2[n4] = fArray2[n4] + f;
        }
        float f = LSHapBaum.sum(this.fwdHapProbs[n]);
        LSHapBaum.scale(this.fwdHapProbs[n], f);
        LSHapBaum.scale(this.bwdHapProbs[n], f);
    }

    private static float sum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return f;
    }

    private static void scale(float[] fArray, float f) {
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
    }

    private static float threshold(int n) {
        return Math.min(0.005f, 1.0f / (float)n);
    }

    private void setAlleleProbs(float[] fArray) {
        this.setFirstAlleleProbs(fArray);
        int n = this.refHapSegs.nSegs() - 1;
        for (int i = 1; i < n; ++i) {
            this.setAlleleProbs(fArray, i);
        }
        this.setLastAlleleProbs(fArray);
    }

    private void setFirstAlleleProbs(float[] fArray) {
        int n = 0;
        int n2 = this.refHapSegs.nSeq(n);
        int n3 = this.refHapSegs.segStart(n + 1);
        float f = LSHapBaum.threshold(n2);
        for (int i = 0; i < n2; ++i) {
            if (!(this.bwdHapProbs[n][i] >= f)) continue;
            for (int j = 0; j < n3; ++j) {
                int n4 = this.refMarkers.sumAlleles(j);
                int n5 = this.refHapSegs.allele(n, j, i);
                int n6 = n4 + n5;
                fArray[n6] = fArray[n6] + this.bwdHapProbs[n][i];
            }
        }
    }

    private void setAlleleProbs(float[] fArray, int n) {
        assert (n > 0);
        int n2 = this.refHapSegs.segStart(n);
        int n3 = this.refHapSegs.segEnd(n - 1);
        int n4 = this.refHapSegs.segStart(n + 1);
        int n5 = this.refHapSegs.nSeq(n);
        float f = LSHapBaum.threshold(n5);
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            int n8;
            boolean bl;
            boolean bl2 = this.fwdHapProbs[n - 1][i] >= f;
            boolean bl3 = bl = this.bwdHapProbs[n][i] >= f;
            if (bl2) {
                for (n8 = n2; n8 < n3; ++n8) {
                    n7 = this.refMarkers.sumAlleles(n8);
                    n6 = this.refHapSegs.allele(n, n8 - n2, i);
                    int n9 = n7 + n6;
                    fArray[n9] = fArray[n9] + this.fwdHapProbs[n - 1][i];
                }
            }
            if (!bl2 && !bl) continue;
            for (n8 = n3; n8 < n4; ++n8) {
                n7 = this.refMarkers.sumAlleles(n8);
                n6 = this.refHapSegs.allele(n, n8 - n2, i);
                double d = this.impData.weight(n8);
                int n10 = n7 + n6;
                fArray[n10] = (float)((double)fArray[n10] + d * (double)this.fwdHapProbs[n - 1][i]);
                int n11 = n7 + n6;
                fArray[n11] = (float)((double)fArray[n11] + (1.0 - d) * (double)this.bwdHapProbs[n][i]);
            }
        }
    }

    private void setLastAlleleProbs(float[] fArray) {
        int n = this.refHapSegs.nSegs() - 1;
        int n2 = n - 1;
        int n3 = this.refHapSegs.segStart(n);
        int n4 = this.refHapSegs.segEnd(n);
        int n5 = this.refHapSegs.nSeq(n);
        float f = LSHapBaum.threshold(n5);
        for (int i = 0; i < n5; ++i) {
            if (!(this.fwdHapProbs[n2][i] >= f)) continue;
            for (int j = n3; j < n4; ++j) {
                int n6 = this.refMarkers.sumAlleles(j);
                int n7 = this.refHapSegs.allele(n, j - n3, i);
                int n8 = n6 + n7;
                fArray[n8] = fArray[n8] + this.fwdHapProbs[n2][i];
            }
        }
    }

    private int nextIndex() {
        ++this.arrayIndex;
        if (this.arrayIndex == this.fwdVal.length) {
            ++this.windowIndex;
            this.arrayIndex = this.windowIndex;
        }
        return this.arrayIndex;
    }

    private int currentIndex() {
        return this.arrayIndex;
    }

    private int previousIndex(int n) {
        if (this.arrayIndex == this.windowIndex) {
            --this.windowIndex;
            this.arrayIndex = this.windowIndex;
            int n2 = this.fwdValueIndex2Marker[this.arrayIndex] + 1;
            int n3 = n2 + (this.fwdVal.length - (this.arrayIndex + 1));
            this.setForwardValues(n2, n3, n);
            return this.arrayIndex;
        }
        return --this.arrayIndex;
    }
}

