/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.Arrays;
import vcf.Marker;
import vcf.VcfEmission;

public final class LowMafRefDiallelicGT
implements VcfEmission {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int minorAllele;
    private final int[] minorAlleles;

    public LowMafRefDiallelicGT(Marker marker, Samples samples, int n, int[] nArray) {
        int[] nArray2 = LowMafRefDiallelicGT.checkAndSortIndices(marker, samples, n, nArray);
        this.marker = marker;
        this.samples = samples;
        this.nHaps = 2 * samples.nSamples();
        this.majorAllele = 1 - n;
        this.minorAllele = n;
        this.minorAlleles = nArray2;
    }

    private static int[] checkAndSortIndices(Marker marker, Samples samples, int n, int[] nArray) {
        int n2;
        if (marker.nAlleles() != 2 || n < 0 || n > 1) {
            throw new IllegalArgumentException("ERROR: inconsistent data");
        }
        int[] nArray2 = (int[])nArray.clone();
        Arrays.sort(nArray2);
        for (n2 = 1; n2 < nArray2.length; ++n2) {
            if (nArray2[n2] != nArray2[n2 - 1]) continue;
            throw new IllegalArgumentException("ERROR: inconsistent data");
        }
        n2 = 2 * samples.nSamples();
        if (nArray2.length > 0 && (nArray2[0] < 0 || nArray2[nArray2.length - 1] >= n2)) {
            throw new IllegalArgumentException("ERROR: inconsistent data");
        }
        return nArray2;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public int nHaps() {
        return this.nHaps;
    }

    @Override
    public int nHapPairs() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (n2 != 0 && n2 != 1) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 != 0 && n3 != 1) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        if (n >= this.samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.allele(2 * n);
    }

    @Override
    public int allele2(int n) {
        return this.allele(2 * n + 1);
    }

    @Override
    public int allele(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (Arrays.binarySearch(this.minorAlleles, n) >= 0) {
            return this.minorAllele;
        }
        return this.majorAllele;
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices() {
        return true;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele;
    }

    @Override
    public int alleleCount(int n) {
        if (n == this.majorAllele) {
            throw new IllegalArgumentException("major allele");
        }
        return this.minorAlleles.length;
    }

    @Override
    public int hapIndex(int n, int n2) {
        if (n == this.majorAllele) {
            throw new IllegalArgumentException("major allele");
        }
        return this.minorAlleles[n2];
    }

    public String toString() {
        return this.toVcfRec();
    }
}

