% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeFlapjack.R
\name{writeFlapjack}
\alias{writeFlapjack}
\title{Write to Flapjack format}
\usage{
writeFlapjack(
  IBDprob,
  outFileMap = "ibd_map.txt",
  outFileGeno = "ibd_geno.txt"
)
}
\arguments{
\item{IBDprob}{An object of class \code{IBDprob}.}

\item{outFileMap}{A character string, the full path to the output map file.}

\item{outFileGeno}{A character string, the full path to the output genotype
file.}
}
\value{
No output. Output files are written to a folder.
}
\description{
Export the results of an IBD calculation to Flapjack format so it can be
visualized there.
}
\examples{
## Compute IBD probabilities for Steptoe Morex.
SxMIBD <- calcIBD(popType = "DH",
                  markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                          package = "statgenIBD"),
                  mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                       package = "statgenIBD"))

## Write output in Flapjack format to temporary files.
writeFlapjack(SxMIBD,
              outFileMap = tempfile(fileext = ".txt"),
              outFileGeno = tempfile(fileext = ".txt"))

}
