% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readIBDs.R
\name{readIBDs}
\alias{readIBDs}
\title{Read IBD probabilities from file}
\usage{
readIBDs(infile, map)
}
\arguments{
\item{infile}{A character string specifying the path of the input file.
Compressed files with extension ".gz" or ".bz2" are supported as well.}

\item{map}{A data.frame with columns \code{chr} for chromosome and
\code{pos} for position. Positions should be in centimorgan (cM). They
should not be cumulative over the chromosomes. Other columns are ignored.
Marker names should be in the row names. These should match the marker names
in the input file.}
}
\value{
An object of class \code{IBDprob}.
}
\description{
Reads IBD probabilities from a plain text, tab-delimited .txt or .ibd file.
Information about the file format can be found in the vignette (
\code{vignette("IBDFileFormat", package = "statgenIBD")}). A data.frame with
the map must be specified as well.
}
\examples{
## Read map for Steptoe Morex.
SxMmap <- read.delim(system.file("extdata/SxM", "SxM_map.txt",
                               package = "statgenIBD"), header = FALSE)
rownames(SxMmap) <- SxMmap$V1
SxMmap <- SxMmap[, -1]
colnames(SxMmap) <- c("chr", "pos")


## Read IBD probabilities for Steptoe Morex.
SxMIBD <- readIBDs(system.file("extdata/SxM", "SxM_IBDs.txt",
                               package = "statgenIBD"),
                  map = SxMmap)

## Print summary.
summary(SxMIBD)

}
