% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{Extract statistics from Fitted Models}
\usage{
extract(
  STA,
  trials = names(STA),
  traits = NULL,
  what = "all",
  keep = NULL,
  restoreColNames = FALSE
)
}
\arguments{
\item{STA}{An object of class STA.}

\item{trials}{A character vector of trials for which the statistics should be
computed. If not supplied, statistics are computed for all trials that have
been modeled.}

\item{traits}{A character vector of traits for which the statistics should be
computed. If not supplied, statistics are computed for all traits that have
been modeled.}

\item{what}{A character vector indicating which statistics should be
computed. Most statistics are available for all models, some only for models
fitted using a certain engine. If this is the case, this is indicated in the
list with options in details.\cr
If \code{what = "all"}, all available statistics are computed.}

\item{keep}{A character vector of column(s) in the object of class
\code{\link{TD}} used for modeling. These columns will be kept as output when
computing fitted values, residuals, standardized residuals and rMeans.
Columns can also be kept when computing (se)BLUEs and (se)BLUPs but only if
the column to keep contains unique values for the modeled variables, i.e. a
column repId with several different values per genotype cannot be kept.}

\item{restoreColNames}{Should the original column names be restored in the
output of the extracted data?}
}
\value{
A list with, per trial for which statistics have been extracted, a
list of those statistics.
}
\description{
This function extracts and calculates various results for fitted models such
as BLUEs, BLUPs, unit errors and heritabilities. Note that most results can
only be calculated if a model is fitted with genotype as fixed or random.
This is indicated in the list below with "F" and "R"
}
\details{
Possible options for \code{what} are:
\describe{
\item{F - BLUEs}{Best Lineair Unbiased Estimators.}
\item{F - seBLUES}{Standard errors of the BLUEs.}
\item{R - BLUPs}{Best Lineair Unbiased Predictors.}
\item{R - seBLUPs}{Standard errors of the BLUPs.}
\item{F - ue}{Unit errors - only for \code{lme4} and \code{asreml}.}
\item{R - heritability}{Heritability.}
\item{F - varCompF}{Variance components for model with genotype as fixed
component.}
\item{R - varCompR}{Variance components for model with genotype as random
component.}
\item{R - varGen}{Genetic variance component(s).}
\item{R - varErr}{Residual variance component(s) - only for \code{lme4}
and \code{asreml}.}
\item{R - varSpat}{Spatial variance components - only for \code{SpATS}.}
\item{F - fitted}{Fitted values for the model with genotype as fixed
component.}
\item{F - residF}{Residuals for the model with genotype as fixed component.}
\item{F - stdResF}{Standardized residuals for the model with genotype as
fixed component}
\item{R - rMeans}{Fitted values for the model with genotype as random
component.}
\item{R - ranEf}{Random genetic effects.}
\item{F - residR}{Residuals for the model with genotype as random component.}
\item{F - stdResR}{Standardized residuals for the model with genotype as
random component}
\item{F - wald}{Results of the wald test - only for \code{lme4} and
\code{asreml}.}
\item{F - CV}{Coefficient of variation - only for \code{lme4} and
\code{asreml}.}
\item{F - rDfF}{Residual degrees of freedom for the model with genotype as
fixed component.}
\item{R - rDfR}{Residual degrees of freedom for the model with genotype as
random component.}
\item{R - effDim}{Effective dimensions - only for \code{SpATS}.}
\item{R - ratEffDim}{Ratio's of the effective dimensions -
only for \code{SpATS}.}
\item{F - sed}{Standard error of difference - only for \code{asreml}.}
\item{F - lsd}{Least significant difference - only for \code{asreml}.}
\item{all}{All available statistics.}
}
}
\examples{
## Fit model using SpATS.
myModel <- fitTD(TD = TDHeat05, design = "res.rowcol", traits = "yield")

## Extract all available statistics from the fitted model.
extr <- extract(myModel)

## Extract only the BLUEs from the fitted model.
BLUEs <- extract(myModel, what = "BLUEs")

## Extract only the BLUEs from the fitted model and keep trial as variable in
## the output.
BLUEs2 <- extract(myModel, what = "BLUEs", keep = "trial")

}
\seealso{
\code{\link{fitTD}}
}
