% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{TDHeat05}
\alias{TDHeat05}
\title{Field data for a wheat experiment in Mexico}
\format{
A TD object, a list containing a data.frame with the following
columns:
\describe{
\item{trial}{trial, a combination of watering regime, year and nitrogen
treatment}
\item{genotype}{genotype}
\item{Plot}{plot number in the field}
\item{repId}{replicate}
\item{subBlock}{block id}
\item{rowId}{row within the field (as factor)}
\item{colId}{column within the field (as factor)}
\item{yield}{yield in grams per square meter}
\item{rowCoord}{row within the field (as numerical value)}
\item{colCoord}{column within the field (as numerical value)}
}
}
\usage{
TDHeat05
}
\description{
A dataset converted to a TD object containing raw plot data for one trial
from a series of wheat trials conducted in Mexico by CIMMYT. The different
trials took place under different regimes of irrigation and temperature,
there were 4 trials across two years, labelled as DRIP05, HEAT05, HEAT06 and
IRRI06. The TD object only contains the data for HEAT05. Within each trial,
a set of 167 progeny of a RIL (Recombinant Inbred Line; 8 generations)
population were tested alongside the population parents (Seri and Babax). A
lattice design with two replicates was used for each trial. In the first
replicate the entries were not randomized, as they were considered to be a
random selection from a population.
}
\keyword{datasets}
