% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrender.R
\name{detrender}
\alias{detrender}
\title{Within-person linear detrending for multilevel VAR analysis}
\usage{
detrender(
  df,
  id_var,
  time_var,
  vars_to_detrend,
  alpha = 0.05,
  min_obs = 3
)
}
\arguments{
\item{df}{Data frame or tibble (long format).}

\item{id_var}{Character string. Subject identifier column (required).}

\item{time_var}{Character string. Numeric time index column (required).}

\item{vars_to_detrend}{Character vector. Column names to detrend within each subject (required).}

\item{alpha}{Numeric in (0,1). Significance threshold for retaining a non-zero time slope (default: 0.05).}

\item{min_obs}{Integer >2. Minimum observations per subject-variable to attempt detrending (default: 3).}
}
\value{
A named list with:
\describe{
  \item{\code{df}}{Tibble. The original dataset with additional detrended columns.}
  \item{\code{n_clusters}}{Integer. Number of unique subjects (clusters) processed.}
  \item{\code{total_trends}}{Integer. Total number of individual trends removed across all variables.}
  \item{\code{summary}}{Tibble. Number of removed linear trends per variable, with columns \code{variable} and \code{removed_trends}.}
}
}
\description{
Remove individual-specific linear trends from panel data to approximate stationarity,
preparing inputs for multilevel Vector Autoregressive (VAR) modeling (among others). 
For each subject and each selected variable, a linear regression of the variable on the time index is
tested at significance level \code{alpha}; if the slope is significant, the fitted trend
is subtracted and the subject's mean is re-added to produce detrended series while
preserving between-subject information.
}
\examples{
df_example <- data.frame(
id = rep(1:2, each = 5),
time = rep(1:5, 2),
x = rep(1:5, 2) + rnorm(10)
)
res <- statioVAR::detrender(
df = df_example,
id_var = "id",
time_var = "time",
vars_to_detrend = "x",
alpha = 0.05,
min_obs = 3
)
res$df[7:9,]
res$n_clusters
res$total_trends
res$summary

}
