% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_properties.R, R/kernelfun.R,
%   R/kernelsList.R
\name{kernel_properties}
\alias{kernel_properties}
\alias{kernelfun}
\alias{kernelfun.function}
\alias{kernelfun.character}
\alias{.kernelsList}
\title{Smoothing kernels}
\usage{
kernel_properties(name, derivative = FALSE)

kernelfun(name, ...)

\method{kernelfun}{function}(name, ...)

\method{kernelfun}{character}(name, derivative = FALSE, ...)

.kernelsList()
}
\arguments{
\item{name}{character. 
The name of the kernel to be used. 
Authorized kernels are listed in \code{\link{.kernelsList}()}.}

\item{derivative}{logical. If \code{TRUE}, the derivative of the kernel 
is returned.}

\item{...}{Additional arguments to be passed to the kernel function.}
}
\value{
A function.
}
\description{
The generic function \code{kernelfun} creates 
a smoothing kernel function.
}
\examples{
kernel_properties("gaussian")

k <- kernelfun("epanechnikov")
curve(k(x), xlim = c(-1, 1))

}
\seealso{
\code{\link[stats]{density}} in package \pkg{stats}.
}
