% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFormulae.r
\name{.removeVerbotenVariables}
\alias{.removeVerbotenVariables}
\title{Remove formula with unwanted terms.}
\usage{
.removeVerbotenVariables(forms, verboten)
}
\arguments{
\item{forms}{List of characters each representing a formula.}

\item{verboten}{Either \code{NULL} (default) in which case \code{forms} is returned without any manipulation. Alternatively, this is a character list of terms that are not allowed to appear in any model in \code{forms}. Models with these terms are removed from \code{forms}. Note that the order of variables in interaction terms does not matter (e.g., \code{x1:x2} will cause the removal of models with this term verbatim as well as \code{x2:x1}). All possible permutations of three-way interaction terms are treated similarly.}
}
\value{
A list of character elements representing formulae.
}
\description{
This function takes as an argument a list of character strings representing formulae and returns a potentially shortened list without formulae containing a certain term.
}
\keyword{internal}
