% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{forkTimeout}
\alias{forkTimeout}
\title{Evaluate an \R expression with a hard time limit by forking a process}
\usage{
forkTimeout(expr, timeout, unsupported = c("warning", "error", "message",
  "silent"), onTimeout = NULL)
}
\arguments{
\item{expr}{expression to be evaluated.}

\item{timeout}{number of seconds to wait for the expression to
evaluate.}

\item{unsupported}{a character vector of length 1 specifying how to
handle a platform that does not support
#ifndef windows
\code{\link[parallel:mcparallel]{parallel::mcparallel()}},
#endif
#ifdef windows
\code{parallel::mcparallel()},
#endif
\describe{

\item{\code{"warning"} or \code{"message"}}{Issue a warning or a message,
respectively, then evaluate the expression without the time limit
enforced.}

\item{\code{"error"}}{Stop with an error.}

\item{\code{"silent"}}{Evaluate the expression without the time limit
enforced, without any notice.}

} Partial matching is used.}

\item{onTimeout}{Value to be returned on time-out.}
}
\value{
Result of evaluating \code{expr} if completed, \code{onTimeout}
otherwise.
}
\description{
This function uses
#ifndef windows
\code{\link[parallel:mcparallel]{parallel::mcparallel()}},
#endif
#ifdef windows
\code{parallel::mcparallel()},
#endif
so the time limit is not
enforced on Windows. However, unlike functions using \code{\link[=setTimeLimit]{setTimeLimit()}}, the time
limit is enforced even on native code.
}
\note{
\code{onTimeout} can itself be an expression, so it is, for
example, possible to stop with an error by passing
\code{onTimeout=stop()}.

Note that this function is not completely transparent:
side-effects may behave in unexpected ways. In particular, RNG
state will not be updated.
}
\examples{

forkTimeout({Sys.sleep(1); TRUE}, 2) # TRUE
forkTimeout({Sys.sleep(1); TRUE}, 0.5) # NULL (except on Windows)
}
