% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.lc.stdmean.bs}
\alias{size.ci.lc.stdmean.bs}
\title{Sample size for a between-subjects standardized mean linear contrast
confidence interval}
\usage{
size.ci.lc.stdmean.bs(alpha, d, w, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{d}{planning value of standardized linear contrast}

\item{w}{desired confidence interval width}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required to estimate a standardized linear contrast of population means
with desired confidence interval precision in a between-subjects design.
Set the standardized mean contrast planning value to the largest value
within a plausible range for a conservatively large sample size.
}
\examples{
v <- c(.5, .5, -.5, -.5)
size.ci.lc.stdmean.bs(.05, 1, .6, v)

# Should return:
#      Sample size per group
# [1,]                    49
 

}
\references{
\insertRef{Bonett2009}{statpsych}
}
