% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.rsqr}
\alias{ci.rsqr}
\title{Confidence interval for squared multiple correlation}
\usage{
ci.rsqr(alpha, r2, s, n)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{r2}{estimated unadjusted squared multiple correlation}

\item{s}{number of predictor variables}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item R-squared - estimate of unadjusted R-squared
\item adj R-squared - bias adjusted R-squared estimate
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes an approximate confidence interval for a population squared
multiple correlation in a linear model with random predictor variables.
This function uses the scaled central F approximation method.
}
\examples{
ci.rsqr(.05, .241, 3, 116)

# Should return:
#        R-squared    adj R-squared          LL        UL
# [1,]       0.241        0.2206696  0.09819599 0.3628798
 

}
\references{
\insertRef{Helland1987}{statpsych}
}
