% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.stdmean.strat}
\alias{ci.stdmean.strat}
\title{Confidence interval for a 2-group standardized mean difference with
stratified sampling}
\usage{
ci.stdmean.strat(alpha, m1, m2, sd1, sd2, n1, n2, p1)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}

\item{p1}{proportion of total population in subpopulation 1}
}
\value{
Returns a 3-row matrix. The columns are:
\itemize{
\item Estimate - bias adjusted standardized mean difference
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for a population standardized mean difference
in a 2-group nonexperimental design with stratified random sampling (a random
sample of a specificied size from each subpopulation) using a square root
weighted variance standardizer or single group standard deviation
standardizer.  Equality of variances is not assumed.
}
\examples{
ci.stdmean.strat(.05, 30.2, 30.8, 10.5, 11.2, 200, 200, .533)

# Should return:
#                           Estimate         SE         LL        UL
# Weighted standardizer: -0.05528428 0.10023259 -0.2518410 0.1410636
# Group 1 standardizer:  -0.05692722 0.10368609 -0.2603639 0.1460782
# Group 2 standardizer:  -0.05692722 0.09720571 -0.2440911 0.1369483


}
\references{
\insertRef{Bonett2020a}{statpsych}
}
