% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.stdmean.ps}
\alias{size.ci.stdmean.ps}
\title{Sample size for a paired-samples standardized mean difference confidence
interval}
\usage{
size.ci.stdmean.ps(alpha, d, cor, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{d}{planning value of standardized mean difference}

\item{cor}{planning value of correlation between measurements}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size for each standardizer
}
\description{
Computes the sample size required to estimate two types of population
standardized mean differences (unweighted standardizer and single group
standardizer) with desired confidence interval precision in a paired-samples
design. For a conservatively large sample size, set the standardized mean
difference planning value to the largest value within a plausible range and
set the Pearson correlation planning value to the smallest value within a
plausible range.
}
\examples{
size.ci.stdmean.ps(.05, 1, .65, .6)

# Should return:
#                            Sample Size
# Unweighted standardizer:            46
# Single group standardizer:          52
 

}
\references{
\insertRef{Bonett2009}{statpsych}0
}
