% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{etasqr.gen.2way}
\alias{etasqr.gen.2way}
\title{Generalized eta-squared estimates in a two-factor design}
\usage{
etasqr.gen.2way(SSa, SSb, SSab, SSe)
}
\arguments{
\item{SSa}{sum of squares for factor A}

\item{SSb}{sum of squares for factor B}

\item{SSab}{sum of squares for A x B interaction}

\item{SSe}{error (within) sum of squares}
}
\value{
Returns a 3-row matrix. The columns are:
\itemize{
\item A - estimate of eta-squared for factor A
\item B - estimate of eta-squared for factor B
\item AB - estimate of eta-squared for A x B interaction
}
}
\description{
Computes generalized eta-square estimates in a two-factor design where one
or both factors are classification factors. If both factors are treatment
factors, then partial eta-square estimates are typically recommended.
The eta-squared estimates from this function can be used in the
\link[statpsych]{etasqr.adj}) function to obtain bias adjusted estimates.
}
\examples{
etasqr.gen.2way(12.3, 15.6, 5.2, 7.9)

# Should return:
#                                           A         B        AB
# A treatment, B classification:      0.300000 0.5435540 0.1811847
# A classification, B treatment:      0.484252 0.3804878 0.2047244
# A classification, B classification: 0.300000 0.3804878 0.1268293
 

}
