% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{sim.ci.stdmean.ps}
\alias{sim.ci.stdmean.ps}
\title{Simulates confidence interval coverage probability for a standardized mean
difference in a paired-samples design}
\usage{
sim.ci.stdmean.ps(alpha, n, sd.ratio, cor, dist1, dist2, d, rep)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{sample size}

\item{sd.ratio}{ratio of population standard deviations (sd2/sd1)}

\item{cor}{correlation between paired measurements}

\item{dist1}{type of distribution at level 1 (1, 2, 3, 4, or 5)}

\item{dist2}{type of distribution at level 2 (1, 2, 3, 4, or 5)
\itemize{
\item 1 = Gaussian (skewness = 0 and excess kurtosis = 0)
\item 2 = platykurtic (skewness = 0 and excess kurtosis = -1.2)
\item 3 = leptokurtic (skewness = 0 and excess kurtosis = 6)
\item 4 = moderate skew (skewness = 1 and excess kurtosis = 1.5)
\item 5 = large skew (skewness = 2 and excess kurtosis = 6)
}}

\item{d}{population standardized mean difference}

\item{rep}{number of Monte Carlo samples}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Coverage - Probability of confidence interval including population std mean difference
\item Lower Error - Probability of lower limit greater than population std mean difference
\item Upper Error - Probability of upper limit less than population std mean difference
\item Ave CI Width - Average confidence interval width
}
}
\description{
Performs a computer simulation of confidence interval performance for
two types of standardized mean differences in a paired-samples design (see
ci.stdmean.ps). Sample data for the two levels of the within-subjects factor
can be generated from five different population distributions. All
distributions are scaled to have standard deviations of 1.0 at level 1.
}
\examples{
sim.ci.stdmean.ps(.05, 20, 1.5, .8, 4, 4, .5, 2000)

# Should return (within sampling error):
#                         Coverage Lower Error Upper Error Ave CI Width   Ave Est
# Unweighted Standardizer   0.9095      0.0555       0.035    0.7354865 0.5186796
# Level 1 Standardizer      0.9525      0.0255       0.022    0.9330036 0.5058198


}
