% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{signal}
\alias{signal}
\title{Parameter estimates for a signal detection study}
\usage{
signal(f1, f2, n1, n2)
}
\arguments{
\item{f1}{number of "Yes" responses in the stimulus (old item) trials}

\item{f2}{number of "Yes" responses in the noise (new item) trials}

\item{n1}{number of stimulus (or old item) trials}

\item{n2}{number of noise (or new item) trials}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item HR - estimate of hit rate
\item FAR - estimate of false alarm rate
\item d-prime - estimate of d-prime
\item Threshold - estimate of threshold (criterion)
\item Bias - estimate of threshold minus d-prime/2
}
}
\description{
Computes the hit rate, false alarm rate, d-prime, threshold, and bias
for one participant (observer) in a Yes/No signal detection study.
An equal-variance Gausian model is assumed. The parameter estimates are
computed after adding .5 to the number of "Yes" responses in each condtion
(the signal and noise conditions) and adding 1 to the number of signal
trials and to the number of noise trails. In memory recognition studies,
the observers is first presented with set of words or images to study,
and is later presented with another set of words or images where some
items are from the first list (old items) and some items are new items.
}
\examples{
signal(82, 46, 100, 100)

# Should return:
#         HR      FAR  d-prime  Threshold       Bias
#  0.8168317 0.460396 1.002793 0.09943603 -0.4019603


}
\references{
\insertRef{Wickens2002}{statpsych}
}
