% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mod_error.R
\name{mod_error}
\alias{mod_error}
\title{Add model error to datasets}
\usage{
mod_error(data, case.ids, outcome, conditions, type,
number, reps, analyze, max.cond.plot, ...)
}
\arguments{
\item{data}{a data frame}

\item{case.ids}{optional character vector containing variable names that identify cases}

\item{outcome}{a character string containing the name of the outcome variable}

\item{conditions}{optional character vector indicating explanatory variables}

\item{type}{a character string indicating the type of set membership scores in the data; takes either
"crisp" for crisp-set data, or "fuzzy" for fuzzy-set data}

\item{number}{a numeric vector indicating the number of random variables to be added to the data}

\item{reps}{number of perturbed datasets to create}

\item{analyze}{logical; if TRUE, carry out frequency analysis of conditions}

\item{max.cond.plot}{maximum number of conditions to plot for frequency analysis}

\item{...}{optional arguments passed to \code{eqmcc()}}
}
\value{
Returns a named list containing the following components:

\item{\code{datasets}}{a list of data frames containing model specification error}
\item{\code{result.freq}}{a data frame containing counts of condition appearances}
\item{\code{plot}}{a plot of condition frequencies (per solution)}
}
\description{
\code{mod_error} creates a list of datasets that contain a
specified type and level of measurement error
}
\examples{
# Load data
data(hicks_29)

# Run function, get three random variables
a<-mod_error(data = hicks_29, case.ids="Case", outcome="CON", type = "crisp",
number = 3, reps = 200, analyze=FALSE)

# Load data
data(hh)

# Run function, get two random variables
a<-mod_error(data = hh, case.ids="Country", outcome="success", type = "fuzzy",
number = 2, reps = 200, analyze=FALSE)
}

