% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/paths_summary.R
\name{paths_summary}
\alias{paths_summary}
\title{Summarize an STCM dataset}
\usage{
paths_summary(data, case.ids, outcome, conditions, plot, verbose,
size.warn)
}
\arguments{
\item{data}{a data frame}

\item{case.ids}{optional character vector containing variable names that identify cases}

\item{outcome}{a character string containing the name of the outcome variable}

\item{conditions}{an optional character vector containing the names of the causal factors}

\item{plot}{logical; if \code{TRUE}, a plot of causal pathways is returned}

\item{verbose}{logical; if \code{TRUE}, information on code execution will be printed}

\item{size.warn}{logical; if \code{TRUE}, prompts the user to authorize execution when number of causal paths >=1000}
}
\value{
Returns a named list with the following components:

\item{\code{n.cases}}{number of cases in the dataset}
\item{\code{n.cases.table}}{a data frame containing the number of unique cases for each variable in \code{case.ids}}
\item{\code{n.paths.possible}}{number of possible paths to the outcome}
\item{\code{n.paths.observed}}{number of observed unique paths to the outcome}
\item{\code{n.paths.percent}}{percent of possible paths to the outcome observed}
\item{\code{paths.obs}}{a data frame containing the observed unique paths to the outcome}
\item{\code{paths.unobs}}{a data frame containing the observed unique paths to the outcome}
\item{\code{freq.paths.obs}}{a data frame containing the observed unique paths to the outcome, the number of cases corresponding
to those paths, and their \code{case.id} values}
\item{\code{var.diversity}}{a data frame containing a measure of diversity in the observed values for each variable;
ranges from 0 (observed values are either all 0 or all 1) to 1 (observed values are equally divided between 0s and 1s)}
\item{\code{paths.plot}}{if \code{plot==TRUE}, a path diagram; solid lines indicate observed paths, while
dotted lines indicate unobserved paths; the outcome values associated with each path are also given}
\item{\code{multicollinearity.df}}{a data frame bivariate correlations and their absolute values for all causal factors}
\item{\code{multicollinearity.avg}}{the average absolute bivariate correlation}
}
\description{
\code{paths_summary} provides descriptions of an STCM dataset related to cases
and causal paths.
}
\examples{
# Load data
data(hicks_20)

# Run function
a<-paths_summary(data = hicks_20, case.ids = "Case", outcome = "CON", plot = TRUE)

# Get number of cases
a$n.cases

# Get number of paths to the outcome observed
a$n.paths.observed

# Get percent of possible paths observed
a$n.paths.percent

# Get multicollinearity
a$multicollinearity.df.avg

# View paths plot
a$paths.plot
}

