% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.r
\name{gcomments}
\alias{gcomments}
\title{Get the comment records of an Steem ID within a period from SteemSQL
gcomments means 'get comment information'.}
\usage{
gcomments(id = NA, from = Sys.Date() - 7, to = Sys.Date(), select = c("root_title", 
    "root_comment", "created", "body"), sql_con, ylab = "Daily Comments", 
    if_plot = FALSE)
}
\arguments{
\item{id}{A character string of a Steem ID}

\item{from}{A Date object or character in '2017-10-24' format of the beginning of the period}

\item{to}{A Date object or character in '2017-10-24' format of the end of the period}

\item{select}{A character string vector of the column names}

\item{sql_con}{A SQL connection}

\item{ylab}{Label on the y-axis}

\item{if_plot}{A logic value of whether plot the time series}
}
\value{
A data frame of the comment information with a figure
}
\description{
Get the comment records of an Steem ID within a period from SteemSQL
gcomments means 'get comment information'.
}
\examples{
\dontrun{
gcomments()
}
}
