% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{get_fields}
\alias{get_fields}
\title{Estimated random field(s)}
\usage{
get_fields(obj, smesh, tmesh, plot = FALSE, sd = FALSE)
}
\arguments{
\item{obj}{A fitted model object returned by \code{\link{fit_lgcp}}.}

\item{smesh}{A Delaunay triangulation of the spatial domain returned by \code{INLA::inla.mesh.2d()}.}

\item{tmesh}{Optional, a temporal mesh returned by \code{INLA::inla.mesh.1d()}.}

\item{plot}{Logical, if \code{TRUE} then the returned values are plotted.
Default \code{FALSE}.}

\item{sd}{Logical, if \code{TRUE} then standard errors returned.
Default \code{FALSE}.}
}
\value{
A \code{numeric} vector or a \code{list} of returned values at each \code{smesh} node.
}
\description{
Extract the estimated mean, or standard deviation, of the 
values of the Gaussian Markov random field for a fitted log-Gaussian
Cox process model at each node of \code{smesh}.
}
\examples{
\donttest{
if(requireNamespace("INLA")) {
data(xyt, package = "stelfi")
domain <- sf::st_as_sf(xyt$window)
locs <- data.frame(x = xyt$x, y = xyt$y)
bnd <- INLA::inla.mesh.segment(as.matrix(sf::st_coordinates(domain)[, 1:2]))
smesh <- INLA::inla.mesh.2d(boundary = bnd, max.edge = 0.75, cutoff = 0.3)
fit <- fit_lgcp(locs = locs, sf = domain, smesh = smesh,
parameters = c(beta = 0, log_tau = log(1), log_kappa = log(1)))
get_fields(fit, smesh, plot = TRUE)
}
}
}
\seealso{
\code{\link{fit_lgcp}} and \code{\link{fit_mlgcp}}
}
