% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_results-class.R
\name{simulation}
\alias{simulation}
\alias{is.simulation_results}
\alias{plot.simulation_results}
\alias{extract_spatial}
\title{Run a simulation}
\usage{
simulation(landscape, population_dynamics, habitat_dynamics = list(),
  demo_stochasticity = c("full", "deterministic_redistribution",
  "stochastic_redistribution", "none"), timesteps = 3, replicates = 1,
  verbose = TRUE)

is.simulation_results(x)

\method{plot}{simulation_results}(x, object = "population",
  type = "graph", stages = NULL, animate = FALSE,
  timesteps = c(1:3), panels = c(3, 3), emp = FALSE, ...)

extract_spatial(x, replicate = 1, timestep = 1,
  landscape_object = "population", stage = 1, misc = 1)
}
\arguments{
\item{landscape}{a \link[steps]{landscape} object representing the initial habitat and
population}

\item{population_dynamics}{a \link[steps]{population_dynamics} object describing how
population changes over time}

\item{habitat_dynamics}{optional list of functions to modify the landscape at
each timestep - see \link[steps]{habitat_dynamics_functions}}

\item{demo_stochasticity}{how should population rounding occur, if at all -
"full" uses a multinomial draw to return rounded cell populations (default);
"deterministic_redistribution" redistributes the decimal overages to the
cells with the largest overages; "stochastic_redistribution" redistributes
the decimal overages to the cells based on binomial draws using the
overages as probabilities; "none" returns non-integer cell populations (no
rounding). Note, this parameter specification is used consistently throughout
all functions in a simulation.}

\item{timesteps}{number of timesteps used in one simulation or timesteps to
display when plotting rasters}

\item{replicates}{number of simulations to perform}

\item{verbose}{print messages and progress to console? (default is TRUE)}

\item{x}{a simulation_results object}

\item{object}{the \code{simulation_results} object to plot - can be 'population'
(default), 'suitability' or 'carrying_capacity'}

\item{type}{the plot type - 'graph' (default) or 'raster'}

\item{stages}{life-stages to plot - must be specified for 'raster' plot
types; by default all life-stages will be plotted}

\item{animate}{if plotting type 'raster' would you like to animate the
rasters?}

\item{panels}{the number of columns and rows to use when plotting raster
timeseries - default is 3 x 3 (e.g. c(3,3) )}

\item{emp}{should the expected minimum population of the simulation be
plotted?}

\item{...}{further arguments passed to or from other methods}

\item{replicate}{which replicate to extract from a \code{simulation_results}
object}

\item{timestep}{which timestep(s) to extract from a \code{simulation_results}
object}

\item{landscape_object}{which landscape object to extract from a
\code{simulation_results} object - can be specified by name
(e.g. "suitability") or index number}

\item{stage}{which life-stage to extract from a \code{simulation_results}
object - only used for 'population' components of the landscape object}

\item{misc}{which misc object to extract from a \code{simulation_results}
object - only used for additional spatial objects added to a landscape
(e.g. disturbance layers)}
}
\value{
An object of class \code{simulation_results}
}
\description{
A simulation changes landscape objects based on selected dynamics over a
specified number of timesteps.
}
\examples{

library(steps)
library(raster)
library(future)
plan(sequential)

landscape <- landscape(population = egk_pop,
               suitability = egk_hab,
               carrying_capacity = egk_k)

pop_dynamics <- population_dynamics(change = growth(transition_matrix = egk_mat))

results <- simulation(landscape, pop_dynamics, timesteps = 10, replicates = 3)

# Test if object is of the type 'simulation_results'

is.simulation_results(results)

plot(results)

# Extract spatial components from a 'simulation_results' object

extract_spatial(results)
}
