
# `stevedata`: Steve’s Toy Data for Teaching About a Variety of Methodological, Social, and Political Topics

[![](https://www.r-pkg.org/badges/version/stevedata?color=green)](https://cran.r-project.org/package=stevedata)
[![](http://cranlogs.r-pkg.org/badges/grand-total/stevedata?color=green)](https://cran.r-project.org/package=stevedata)
[![](http://cranlogs.r-pkg.org/badges/last-month/stevedata?color=green)](https://cran.r-project.org/package=stevedata)
[![](http://cranlogs.r-pkg.org/badges/last-week/stevedata?color=green)](https://cran.r-project.org/package=stevedata)

<img src="http://svmiller.com/images/stevedata-hexlogo.png" alt="My stevedata  hexlogo" align="right" width="200" style="padding: 0 15px; float: right;"/>

`stevedata` is an R package full of toy data sets that you may find
useful for various purposes. Namely, I’ve created probably over a
hundred toy data sets along the way, either to riff on some topic on [my
blog](http://svmiller.com/blog/), show my students something in one of
[my many classes](http://svmiller.com/teaching/), or just to entertain
myself for [spamming Twitter with my assorted
thoughts](https://twitter.com/stevenvmiller). I had stuffed a lot of
these into [`stevemisc`](https://github.com/svmiller/stevemisc), but I
want to keep that package mostly about the functions (and whatever data
are useful for showing off the functions). `stevedata` will have all my
toy data going forward.

I anticipate two sets of R users may find these data useful. First,
instructors may find these data useful for classes on a variety of
topics, but prominently quantitative methods and international
relations. Many of the toy data sets included in this R package are data
I’ve acquired or assembled to teach about topics in quantitative methods
or international relations in a reproducible way. Users should see my
Github repositories for my classes on [introduction to international
relations](https://github.com/svmiller/posc1020), [quantitative methods
in political science](https://github.com/svmiller/posc3410), and
[foundations of social science research for public
policy](https://github.com/svmiller/post8000) to see how I’ve used these
data (or development versions of them). Topics here are diverse,
including (but not limited to) [carbon dioxide emissions over 800,000
years](https://github.com/svmiller/stevedata/blob/master/man/co2emissions.Rd)
(as an illustration of climate change), [coffee
prices](https://github.com/svmiller/stevedata/blob/master/man/coffee_price.Rd)
(as an illustration of the worsening [terms of
trade](https://www.economicsonline.co.uk/Global_economics/Terms_of_trade.html#:~:text=A%20worsening%20terms%20of%20trade,the%20price%20of%20manufactured%20goods.)),
[the justifiability of
bribe-taking](https://github.com/svmiller/stevedata/blob/master/man/wvs_justifbribe.Rd)
(as an illustration of information-poor and discrete variables that a
researcher may be tempted to treat as drawn from a normal distribution),
the canonical case of [illiteracy rates in the 1930 U.S.
Census](https://github.com/svmiller/stevedata/blob/master/man/illiteracy30.Rd)
(as an illustration of an [ecological
fallacy](https://www.britannica.com/science/ecological-fallacy)), and
many, many more topics.

Second, my students in these classes (but especially my methods classes)
should find this R package useful. I will also be having my methods
students (undergraduate and graduate) download this package to work
through problem sets in the R programming language. It’d be a benefit to
them (and less hassle/headache for myself) to have my students download
this package from CRAN rather than work through potential
[`curl`](https://curl.se) issues by installing through Github.

In almost all instances, each data set has an underlying code/script
that generates them. These are in a `data-raw` directory that is not
included in the Github repository or the R package. However, I invite
users to reach out with questions about the data if they have them.

## Installation

This package is now on CRAN. You can download it as you would any other
R package.

``` r
install.packages("stevedata")
```

You can also install the development version of `stevedata` from Github
via the `devtools` package. I suppose using the `remotes` package would
work as well.

``` r
devtools::install_github("svmiller/stevedata")
```

## Usage

The data set already has a lot to offer those who might be curious about
its contents. You can do this to see what is in it.

``` r
data(package = "stevedata")
```

The ensuing output will look like this.

| **Object Name**                                                                               | **Title/Description**                                                                                                 |
|:----------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------|
| [`af_crime93`](http://svmiller.com/stevedata/reference/af_crime93.html)                       | Statewide Crime Data (1993)                                                                                           |
| [`aluminum_premiums`](http://svmiller.com/stevedata/reference/aluminum_premiums.html)         | LME Aluminum Premiums Data                                                                                            |
| [`anes_partytherms`](http://svmiller.com/stevedata/reference/anes_partytherms.html)           | Major Party (Democrat, Republican) Thermometer Index Data (1978-2012)                                                 |
| [`anes_prochoice`](http://svmiller.com/stevedata/reference/anes_prochoice.html)               | Abortion Attitudes (ANES, 2012)                                                                                       |
| [`anes_vote84`](http://svmiller.com/stevedata/reference/anes_vote84.html)                     | Simple Data for a Simple Model of Individual Voter Turnout (ANES, 1984)                                               |
| [`Arca`](http://svmiller.com/stevedata/reference/Arca.html)                                   | NYSE Arca Steel Index data, 2017–present                                                                              |
| [`arcticseaice`](http://svmiller.com/stevedata/reference/arcticseaice.html)                   | Arctic Sea Ice Extent Data, 1901-2015                                                                                 |
| [`arg_tariff`](http://svmiller.com/stevedata/reference/arg_tariff.html)                       | Simple Mean Tariff Rate for Argentina                                                                                 |
| [`asn_stats`](http://svmiller.com/stevedata/reference/asn_stats.html)                         | Aviation Safety Network Statistics, 1942-2019                                                                         |
| [`CFT15`](http://svmiller.com/stevedata/reference/CFT15.html)                                 | Randomization Inference in the Regression Discontinuity Design: An Application to Party Advantages in the U.S. Senate |
| [`clemson_temps`](http://svmiller.com/stevedata/reference/clemson_temps.html)                 | Daily Clemson Temperature Data                                                                                        |
| [`co2emissions`](http://svmiller.com/stevedata/reference/co2emissions.html)                   | Carbon Dioxide Emissions Data                                                                                         |
| [`coffee_imports`](http://svmiller.com/stevedata/reference/coffee_imports.html)               | Coffee Imports for Select Importing Countries                                                                         |
| [`coffee_price`](http://svmiller.com/stevedata/reference/coffee_price.html)                   | The Primary Commodity Price for Coffee (Arabica, Robustas)                                                            |
| [`CP77`](http://svmiller.com/stevedata/reference/CP77.html)                                   | Education Expenditure Data (Chatterjee and Price, 1977)                                                               |
| [`Datasaurus`](http://svmiller.com/stevedata/reference/Datasaurus.html)                       | The Datasaurus Dozen                                                                                                  |
| [`Dee04`](http://svmiller.com/stevedata/reference/Dee04.html)                                 | Are There Civics Returns to Education?                                                                                |
| [`DJIA`](http://svmiller.com/stevedata/reference/DJIA.html)                                   | Dow Jones Industrial Average, 1885-Present                                                                            |
| [`DST`](http://svmiller.com/stevedata/reference/DST.html)                                     | Casualties/Fatalities in the U.S. for Drunk-Driving, Suicide, and Terrorism                                           |
| [`eight_schools`](http://svmiller.com/stevedata/reference/eight_schools.html)                 | The Effect of Special Preparation on SAT-V Scores in Eight Randomized Experiments                                     |
| [`election_turnout`](http://svmiller.com/stevedata/reference/election_turnout.html)           | State-Level Education and Voter Turnout in 2016                                                                       |
| [`eq_passengercars`](http://svmiller.com/stevedata/reference/eq_passengercars.html)           | Export Quality Data for Passenger Cars, 1963-2014                                                                     |
| [`ESS9GB`](http://svmiller.com/stevedata/reference/ESS9GB.html)                               | British Attitudes Toward Immigration (2018-19)                                                                        |
| [`ESSBE5`](http://svmiller.com/stevedata/reference/ESSBE5.html)                               | Trust in the Police in Belgium (European Social Survey, Round 5)                                                      |
| [`eustates`](http://svmiller.com/stevedata/reference/eustates.html)                           | EU Member States (Current as of 2019)                                                                                 |
| [`fakeAPI`](http://svmiller.com/stevedata/reference/fakeAPI.html)                             | Hypothetical (Fake) Data on Academic Performance                                                                      |
| [`fakeLogit`](http://svmiller.com/stevedata/reference/fakeLogit.html)                         | Fake Data for a Logistic Regression                                                                                   |
| [`fakeTSCS`](http://svmiller.com/stevedata/reference/fakeTSCS.html)                           | Fake Data for a Time-Series Cross-Section                                                                             |
| [`fakeTSD`](http://svmiller.com/stevedata/reference/fakeTSD.html)                             | Fake Data for a Time-Series                                                                                           |
| [`ghp100k`](http://svmiller.com/stevedata/reference/ghp100k.html)                             | Gun Homicide Rate per 100,000 People, by Country                                                                      |
| [`gss_abortion`](http://svmiller.com/stevedata/reference/gss_abortion.html)                   | Abortion Opinions in the General Social Survey                                                                        |
| [`gss_spending`](http://svmiller.com/stevedata/reference/gss_spending.html)                   | Attitudes Toward National Spending in the General Social Survey (2018)                                                |
| [`gss_wages`](http://svmiller.com/stevedata/reference/gss_wages.html)                         | The Gender Pay Gap in the General Social Survey                                                                       |
| [`Guber99`](http://svmiller.com/stevedata/reference/Guber99.html)                             | School Expenditures and Test Scores for 50 States, 1994-95                                                            |
| [`illiteracy30`](http://svmiller.com/stevedata/reference/illiteracy30.html)                   | Illiteracy in the Population 10 Years Old and Over, 1930                                                              |
| [`LOTI`](http://svmiller.com/stevedata/reference/LOTI.html)                                   | Land-Ocean Temperature Index, 1880-2020                                                                               |
| [`LTPT`](http://svmiller.com/stevedata/reference/LTPT.html)                                   | Long-Term Price Trends for Computers, TVs, and Related Items                                                          |
| [`LTWT`](http://svmiller.com/stevedata/reference/LTWT.html)                                   | “Let Them Watch TV”                                                                                                   |
| [`min_wage`](http://svmiller.com/stevedata/reference/min_wage.html)                           | History of Federal Minimum Wage Rates Under the Fair Labor Standards Act, 1938-2009                                   |
| [`mm_mlda`](http://svmiller.com/stevedata/reference/mm_mlda.html)                             | Minimum Legal Drinking Age Fatalities Data                                                                            |
| [`mm_nhis`](http://svmiller.com/stevedata/reference/mm_nhis.html)                             | Data from the 2009 National Health Interview Survey (NHIS)                                                            |
| [`mm_randhie`](http://svmiller.com/stevedata/reference/mm_randhie.html)                       | Data from the RAND Health Insurance Experiment (HIE)                                                                  |
| [`mvprod`](http://svmiller.com/stevedata/reference/mvprod.html)                               | Motor Vehicle Production by Country, 1950-2019                                                                        |
| [`nesarc_drinkspd`](http://svmiller.com/stevedata/reference/nesarc_drinkspd.html)             | The Usual Daily Drinking Habits of Americans (NESARC, 2001-2)                                                         |
| [`Newhouse77`](http://svmiller.com/stevedata/reference/Newhouse77.html)                       | Medical-Care Expenditure: A Cross-National Survey (Newhouse, 1977)                                                    |
| [`ODGI`](http://svmiller.com/stevedata/reference/ODGI.html)                                   | Ozone Depleting Gas Index Data, 1992-2019                                                                             |
| [`Presidents`](http://svmiller.com/stevedata/reference/Presidents.html)                       | U.S. Presidents and Their Terms in Office                                                                             |
| [`pwt_sample`](http://svmiller.com/stevedata/reference/pwt_sample.html)                       | Penn World Table (9.1) Macroeconomic Data for Select Countries, 1950-2017                                             |
| [`quartets`](http://svmiller.com/stevedata/reference/quartets.html)                           | Anscombe’s (1973) Quartets                                                                                            |
| [`recessions`](http://svmiller.com/stevedata/reference/recessions.html)                       | United States Recessions, 1855-present                                                                                |
| [`SCP16`](http://svmiller.com/stevedata/reference/SCP16.html)                                 | South Carolina County GOP/Democratic Primary Data, 2016                                                               |
| [`sealevels`](http://svmiller.com/stevedata/reference/sealevels.html)                         | Global Average Absolute Sea Level Change, 1880–2015                                                                   |
| [`so2concentrations`](http://svmiller.com/stevedata/reference/so2concentrations.html)         | Sulfur Dioxide Emissions, 1980-2017                                                                                   |
| [`steves_clothes`](http://svmiller.com/stevedata/reference/steves_clothes.html)               | Steve’s (Professional) Clothes, as of March 3, 2019                                                                   |
| [`sugar_price`](http://svmiller.com/stevedata/reference/sugar_price.html)                     | IMF Primary Commodity Price Data for Sugar                                                                            |
| [`therms`](http://svmiller.com/stevedata/reference/therms.html)                               | Thermometer Ratings for Donald Trump and Barack Obama                                                                 |
| [`turnips`](http://svmiller.com/stevedata/reference/turnips.html)                             | Turnip prices in Animal Crossing (New Horizons)                                                                       |
| [`TV16`](http://svmiller.com/stevedata/reference/TV16.html)                                   | The Individual Correlates of the Trump Vote in 2016                                                                   |
| [`ukg_eeri`](http://svmiller.com/stevedata/reference/ukg_eeri.html)                           | United Kingdom Effective Exchange Rate Index Data, 1990-2019                                                          |
| [`uniondensity`](http://svmiller.com/stevedata/reference/uniondensity.html)                   | Cross-National Rates of Trade Union Density                                                                           |
| [`usa_chn_gdp_forecasts`](http://svmiller.com/stevedata/reference/usa_chn_gdp_forecasts.html) | United States-China GDP and GDP Forecasts, 1960-2050                                                                  |
| [`usa_computers`](http://svmiller.com/stevedata/reference/usa_computers.html)                 | Percentage of U.S. Households with Computer Access, by Year                                                           |
| [`usa_migration`](http://svmiller.com/stevedata/reference/usa_migration.html)                 | U.S. Inbound/Outbound Migration Data, 1990-2017                                                                       |
| [`usa_states`](http://svmiller.com/stevedata/reference/usa_states.html)                       | State Abbreviations, Names, and Regions/Divisions                                                                     |
| [`usa_tradegdp`](http://svmiller.com/stevedata/reference/usa_tradegdp.html)                   | U.S. Trade and GDP, 1790-2018                                                                                         |
| [`wvs_ccodes`](http://svmiller.com/stevedata/reference/wvs_ccodes.html)                       | Syncing Word Values Survey Country Codes with CoW Codes                                                               |
| [`wvs_immig`](http://svmiller.com/stevedata/reference/wvs_immig.html)                         | Attitudes about Immigration in the World Values Survey                                                                |
| [`wvs_justifbribe`](http://svmiller.com/stevedata/reference/wvs_justifbribe.html)             | Attitudes about the Justifiability of Bribe-Taking in the World Values Survey                                         |
| [`wvs_usa_abortion`](http://svmiller.com/stevedata/reference/wvs_usa_abortion.html)           | Attitudes on the Justifiability of Abortion in the United States (World Values Survey, 1982-2011)                     |
| [`yugo_sales`](http://svmiller.com/stevedata/reference/yugo_sales.html)                       | Yugo Sales in the United States, 1985-1992                                                                            |

Here is a simple scraping job to provide more information (by way of the
`description` field in the associated R Documentation file). I include
these descriptions as a vignette as well.

| **Object Name**                                                                               | **Description**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
|:----------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [`af_crime93`](http://svmiller.com/stevedata/reference/af_crime93.html)                       | These data are in Table 9.1 of the 3rd edition of Agresti and Finlay’s *Statistical Methods for the Social Sciences*. The data are from *Statistical Abstract of the United States* and most variables were measured in 1993.                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`aluminum_premiums`](http://svmiller.com/stevedata/reference/aluminum_premiums.html)         | A near daily data set on the price of aluminum premiums (USD/MT) for LME in the U.S., Western Europe, East Asia, and Southeast Asia. I like these data as illustrative of some of the shortsightedness of the aluminum tariffs that Donald Trump announced in March 2018. The tariffs had no discernible effect on manufacturing employment or earnings, but they created a supply shock that made aluminum more expensive.                                                                                                                                                                                                                                                                |
| [`anes_partytherms`](http://svmiller.com/stevedata/reference/anes_partytherms.html)           | A data set on thermometer ratings for the Democratic party, Republican party, “both major parties”, and a major party thermometer index from the American National Election Studies (1978-2012).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`anes_prochoice`](http://svmiller.com/stevedata/reference/anes_prochoice.html)               | A simple data set for in-class illustration about how to estimate and interpret interactive relationships. The data here are deliberately minimal for that end.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`anes_vote84`](http://svmiller.com/stevedata/reference/anes_vote84.html)                     | This is a simple data set for estimating a simple model on voter turnout from the 1984 American National Election Studies (ANES) 1984 time-series.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [`Arca`](http://svmiller.com/stevedata/reference/Arca.html)                                   | Daily data on the NYSE Arca Steel Index. These data are useful for me in teaching how Trump’s 2018 steel tariffs didn’t do much good for the steel industry.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`arcticseaice`](http://svmiller.com/stevedata/reference/arcticseaice.html)                   | This data set from Connelly et al. (2017) measures the Arctic sea ice extent in 10^6 square kilometers. It includes lower bounds and upper bounds on annual averages.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`arg_tariff`](http://svmiller.com/stevedata/reference/arg_tariff.html)                       | Simple mean tariff rate for Argentina, starting in 1980. The goal is to keep these data current.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`asn_stats`](http://svmiller.com/stevedata/reference/asn_stats.html)                         | These are yearly counts on air accidents and fatalities, including measures for corporate jet accidents and hijackings. The hijackings are of particular interest to me, at least from a historical terrorism perspective.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`CFT15`](http://svmiller.com/stevedata/reference/CFT15.html)                                 | This is the replication data for “Randomization Inference in the Regression Discontinuity Design: An Application to Party Advantages in the U.S. Senate”, published in 2015 in Journal of Causal Inference. I use these data to teach about regression discontinuity designs.                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`clemson_temps`](http://svmiller.com/stevedata/reference/clemson_temps.html)                 | This data set contains daily temperatures (highs) for Clemson, South Carolina from Jan. 1, 1930 to the end of the most recent calendar year. The goal is to update this periodically with new data for as long as I live in this town.                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`co2emissions`](http://svmiller.com/stevedata/reference/co2emissions.html)                   | This is a sample data set, cobbled from various sources, about carbon dioxide emissions in the history of the planet from 800,000 BCE to the most recently concluded calendar year. I use this for a data visualization example for a lecture on climate change and international politics. Data communicate yearly averages/estimates.                                                                                                                                                                                                                                                                                                                                                    |
| [`coffee_imports`](http://svmiller.com/stevedata/reference/coffee_imports.html)               | A simple time series on coffee imports for select importing countries (i.e. European Union + Japan + Russia + Tunisia + United States).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [`coffee_price`](http://svmiller.com/stevedata/reference/coffee_price.html)                   | This is primary commodity price data for coffee (Arabica, Robustas) from 1980 to the present. I manually update these data since FRED’s coverage since 2017 has been spotty.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`CP77`](http://svmiller.com/stevedata/reference/CP77.html)                                   | This is a simple data set provided by Chatterjee and Price (1977, p. 108) that serves as a known example of heteroscedasticity.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`Datasaurus`](http://svmiller.com/stevedata/reference/Datasaurus.html)                       | An illustrative exercise in never trusting the summary statistics without also visualizing them.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`Dee04`](http://svmiller.com/stevedata/reference/Dee04.html)                                 | This should be a data set for a (partial?) replication of Dee’s (2004) article on the purported civics returns to education. I use these data for in-class illustration about instrumental variable analyses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`DJIA`](http://svmiller.com/stevedata/reference/DJIA.html)                                   | This data set contains the value of the Dow Jones Industrial Average on daily close for all available dates (to the best of my knowledge) from 1885 to the most recently concluded calendar year. Extensions shouldn’t be too difficult with existing packages.                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`DST`](http://svmiller.com/stevedata/reference/DST.html)                                     | These are fatalities (and, in the case of terrorism, casualties as well) for drunk-driving, suicide, and acts of terrorism in the U.S. spanning 1970 to 2018. Only one of these is sufficiently important to command public attention despite being the least severe public bad. Do you want to guess which one?                                                                                                                                                                                                                                                                                                                                                                           |
| [`eight_schools`](http://svmiller.com/stevedata/reference/eight_schools.html)                 | You’ve all seen these before. These are the “eight schools” that everyone gets when being introduced to Bayesian programming. Here are the full data for your consideration, which you can use instead of awkwardly searching where the data are and copy-pasting them as a list. Every damn time, Steve.                                                                                                                                                                                                                                                                                                                                                                                  |
| [`election_turnout`](http://svmiller.com/stevedata/reference/election_turnout.html)           | A simple data set on education and state-level (+ DC) turnout in the 2016 presidential election. This is inspired by what Pollock (2012) does in his book.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`eq_passengercars`](http://svmiller.com/stevedata/reference/eq_passengercars.html)           | Data from the International Monetary Fund for the export quality and unit/trade value of passenger cars for all available countries and years from 1963 to 2014.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`ESS9GB`](http://svmiller.com/stevedata/reference/ESS9GB.html)                               | This is a replication data originally set to accompany a blog post and presentation to students at the University of Nottingham in March 2020. However, COVID-19 led to the cancellation of the talk.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`ESSBE5`](http://svmiller.com/stevedata/reference/ESSBE5.html)                               | This is a sample data set cobbled from the fifth round of European Social Survey data for Belgium. It offers a means to do a basic replication of some of Chapter 5 of The SAGE Handbook of Regression Analysis and Causal Inference.                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`eustates`](http://svmiller.com/stevedata/reference/eustates.html)                           | European Union membership by accession date                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [`fakeAPI`](http://svmiller.com/stevedata/reference/fakeAPI.html)                             | This is a hypothetical universe of schools in a given territorial unit, patterned off the apipop data available in the survey package.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`fakeLogit`](http://svmiller.com/stevedata/reference/fakeLogit.html)                         | This is a simple fake data set to illustrate a logistic regression.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [`fakeTSCS`](http://svmiller.com/stevedata/reference/fakeTSCS.html)                           | This is a toy (i.e. “fake”) data set created by the fabricatr package. There are 100 observations for 25 hypothetical countries. The outcome y is a linear function of a baseline for each hypothetical country, plus a yearly growth trend as well as varying growth errors for each country. x1 is supposed to have a linear effect of .5 on y, all things considered. x2 is supposed to have a linear effect of 1 on y for each unit change in x2, all things considered.                                                                                                                                                                                                               |
| [`fakeTSD`](http://svmiller.com/stevedata/reference/fakeTSD.html)                             | This is a toy (i.e. “fake”) data set created by the fabricatr package. There are 100 observations. The outcome y is a linear function of 20 + (.25 \* year) + .(25 \* x1) + (1 \* x2) + e. This clearly implies some autocorrelation in the data. I.e. it’s a time-series.                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`ghp100k`](http://svmiller.com/stevedata/reference/ghp100k.html)                             | This is the yearly rate of gun homicides per 100,000 people in the population, selecting on “Western” countries of interest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| [`gss_abortion`](http://svmiller.com/stevedata/reference/gss_abortion.html)                   | This is a toy data set derived from the General Social Survey that I intend to use for several purposes. First, the battery of abortion items can serve as toy data to illustrate mixed effects modeling as equivalent to a one-parameter (Rasch) model. Second, I include some covariates to also do some basic regressions. I think abortion opinions are useful learning tools for statistical inference for college students. Third, there’s a time-series component as well for understanding how abortion attitudes have changed over time.                                                                                                                                          |
| [`gss_spending`](http://svmiller.com/stevedata/reference/gss_spending.html)                   | This is a toy data set that collects attitudes on toward national spending for various things in the General Social Survey for 2018. I use these data for in-class illustration about ordinal variables and ordinal models.                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [`gss_wages`](http://svmiller.com/stevedata/reference/gss_wages.html)                         | Wage data from the General Social Survey (1974-2018) to illustrate wage discrepancies by gender (while also considering respondent occupation, age, and education).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [`Guber99`](http://svmiller.com/stevedata/reference/Guber99.html)                             | A data set for a canonical case of a Simpson’s paradox, useful for in-class instruction on the topic.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`illiteracy30`](http://svmiller.com/stevedata/reference/illiteracy30.html)                   | This is perhaps the canonical data set for illustrating the ecological fallacy.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`LOTI`](http://svmiller.com/stevedata/reference/LOTI.html)                                   | These data contain monthly mean temperature anomalies expressed as deviations from the corresponding 1951-1980 means. They are useful for showing how we can measure climate change.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [`LTPT`](http://svmiller.com/stevedata/reference/LTPT.html)                                   | These data are a monthly time-series of changes in the consumer price index relative to a Dec. 1997 starting date for televisions, computers, and related items. I use this as in-class illustration that globalization has made consumer electronics cheaper across the board for Americans.                                                                                                                                                                                                                                                                                                                                                                                              |
| [`LTWT`](http://svmiller.com/stevedata/reference/LTWT.html)                                   | “Let Them Watch TV”: These data contain price indices for various items for the general urban consumer. Categories include medical services, college tuition, college textbooks, child care, housing, food and beverages, all items (i.e. general CPI), new vehicles, apparel, and televisions. The base period in value was originally the 1982-4 average, but I converted the base period to January 2000. I use these data for in-class discussion about how liberalized trade has made consumer electronics (like TVs) fractions of their past prices. Yet, young adults face mounting costs for college, child-raising, and health care that government policy has failed to address. |
| [`min_wage`](http://svmiller.com/stevedata/reference/min_wage.html)                           | A data set on the various federal minimum wage rates.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`mm_mlda`](http://svmiller.com/stevedata/reference/mm_mlda.html)                             | These are data you can use to replicate the regression discontinuity design analyses throughout Chapter 4 of Mastering ’Metrics. Original analyses come from Carpenter and Dobkin (2009, 2011).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`mm_nhis`](http://svmiller.com/stevedata/reference/mm_nhis.html)                             | These are data from the 2009 NHIS survey. People who have read Mastering ‘Metrics should recognize these data. They’re featured prominently in that book and the authors’ discussion of random assignment and experiments.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`mm_randhie`](http://svmiller.com/stevedata/reference/mm_randhie.html)                       | These are data from the RAND Health Insurance Experiment (HIE).People who have read Mastering ‘Metrics should recognize these data. They’re featured prominently in that book and the authors’ discussion of random assignment and experiments.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`mvprod`](http://svmiller.com/stevedata/reference/mvprod.html)                               | Data, largely from Organisation Internationale des Constructeurs d’Automobiles (OICA), on motor vehicle production in various countries (and the world totals) from 1950 to 2019 at various intervals. Tallies include production of passenger cars, light commercial vehicles, minibuses, trucks, buses and coaches.                                                                                                                                                                                                                                                                                                                                                                      |
| [`nesarc_drinkspd`](http://svmiller.com/stevedata/reference/nesarc_drinkspd.html)             | This toy data set is loosely modified from Wave I of the NESARC data set. Here, my main interest is the number of drinks consumed on a usual day drinking alcohol in the past 12 months, according to respondents in the nationally representative survey of 43,093 Americans.                                                                                                                                                                                                                                                                                                                                                                                                             |
| [`Newhouse77`](http://svmiller.com/stevedata/reference/Newhouse77.html)                       | These are the data in Newhouse’s (1977) simple OLS model from 1977. In his case, he’s trying to explain medical care expenditures as a function of GDP per capita for these countries. It’s probably the easiest OLS model I can find in print because Newhouse helpfully provides all the data in one simple table.                                                                                                                                                                                                                                                                                                                                                                       |
| [`ODGI`](http://svmiller.com/stevedata/reference/ODGI.html)                                   | The NOAA Earth System Research Laboratory has an “ozone depleting gas index” (ODGI) data set from 1992 to 2018. This dataset summarizes Table 1 and Table 2 from its website. The primary interest here (for my purposes) is the ODGI indices (including the new 2012 measure). The data set includes constituent greenhouse gases/chlorines as well in parts per trillion. The primary use here is for in-class illustration.                                                                                                                                                                                                                                                             |
| [`Presidents`](http://svmiller.com/stevedata/reference/Presidents.html)                       | This should be self-evident. Here are all U.S. presidents who have completed their terms in office (i.e. excluding the current one).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [`pwt_sample`](http://svmiller.com/stevedata/reference/pwt_sample.html)                       | These are some macroeconomic data for 21 select (rich) countries. I’ve used these data before to discuss issues of grouping and skew in cross-sectional data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| [`quartets`](http://svmiller.com/stevedata/reference/quartets.html)                           | These are four x-y data sets, combined into a long format, which have the same traditional statistical properties (mean, variance, correlation, regression line, etc.). However, they look quite different.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [`recessions`](http://svmiller.com/stevedata/reference/recessions.html)                       | Data on U.S. recessions, past to present. Data include information on contraction, expansion, and cycle.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [`SCP16`](http://svmiller.com/stevedata/reference/SCP16.html)                                 | County-level data on vote share and various background/demographic information for the 2016 South Carolina GOP/Democratic primaries.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [`sealevels`](http://svmiller.com/stevedata/reference/sealevels.html)                         | These data describe how sea level has changed over time, in both relative and absolute terms. Absolute sea level change refers to the height of the ocean surface regardless of whether nearby land is rising or falling.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| [`so2concentrations`](http://svmiller.com/stevedata/reference/so2concentrations.html)         | This data set contains yearly observations by the Environmental Protection Agency on the concentration of sulfur dioxide in parts per billion, based on 35 sites. I use this for in-class illustration. Note that the national standard is 75 parts per billion.                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`steves_clothes`](http://svmiller.com/stevedata/reference/steves_clothes.html)               | I cobbled together this data set of the professional clothes (polos, long-sleeve dress shirts, pants) in my closet, largely for illustration on the origins of apparel in the U.S. for an intro lecture on trade.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [`sugar_price`](http://svmiller.com/stevedata/reference/sugar_price.html)                     | This is primary commodity price data for sugar globally, in the United States, and in Europe for every month from 1980 to (roughly) the present. Prices are nominal U.S. cents per pound and are not seasonally adjusted (“NSA”).                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [`therms`](http://svmiller.com/stevedata/reference/therms.html)                               | A data set on thermometer ratings for Donald Trump and Barack Obama in 2020. I use these data for in-class illustration of central limit theorem. Basically: the sampling distribution of a population is normal, even if the underlying population is decidedly not.                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`turnips`](http://svmiller.com/stevedata/reference/turnips.html)                             | A data set on turnip prices from my experience with Animal Crossing (New Horizons)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| [`TV16`](http://svmiller.com/stevedata/reference/TV16.html)                                   | These data come from the 2016 CCES and allow interested students to model the individual correlates of the Trump vote in 2016. Code/analysis heavily indebted to a 2017 analysis I did on my blog (see references).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| [`ukg_eeri`](http://svmiller.com/stevedata/reference/ukg_eeri.html)                           | This is a (near) daily data set on the effective exchange rate index for the United Kingdom’s pound sterling from 1990 to 2018. The data are indexed, such that 100 equals the monthly average in January 2005. This is useful for illustrating devaluations of the pound after Black Wednesday, the financial crisis, and, more recently, the UK’s efforts to leave the European Union.                                                                                                                                                                                                                                                                                                   |
| [`uniondensity`](http://svmiller.com/stevedata/reference/uniondensity.html)                   | Cross-national data on relative size of the trade unions and predictors in 20 countries. This is a data set of interest to replicating Western and Jackman (1994), who themselves were addressing a debate between Wallerstein and Stephens on which of two highly correlated predictors explains trade union density.                                                                                                                                                                                                                                                                                                                                                                     |
| [`usa_chn_gdp_forecasts`](http://svmiller.com/stevedata/reference/usa_chn_gdp_forecasts.html) | This is a toy data set to examine the time in which we should expect China to overtake the United States in total gross domestic product (GDP), given current trends. It includes an OECD long-term GDP forecast from 2014, and forecasts from the forecast and prophet packages in R.                                                                                                                                                                                                                                                                                                                                                                                                     |
| [`usa_computers`](http://svmiller.com/stevedata/reference/usa_computers.html)                 | This is a simple and regrettably incomplete time-series on the percentage of U.S. households with access to a computer, by year.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [`usa_migration`](http://svmiller.com/stevedata/reference/usa_migration.html)                 | This data set contains counts/estimates for the number of inbound migrants in the U.S as well as outbound migrants of American origin to other countries from 1990 to 2017.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [`usa_states`](http://svmiller.com/stevedata/reference/usa_states.html)                       | A simple data set from state.abb, state.name, state.region, and state.division (+ District of Columbia). I’d rather just have all these in one place.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| [`usa_tradegdp`](http://svmiller.com/stevedata/reference/usa_tradegdp.html)                   | A yearly data set on U.S. trade and GDP from 1790 to 2018. Data also include a population variable to facilitate per capita adjustments, if the user sees it useful.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [`wvs_ccodes`](http://svmiller.com/stevedata/reference/wvs_ccodes.html)                       | A simple data set that syncs World Values Survey country codes (s003) with corresponding country codes from the Correlates of War state system membership data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [`wvs_immig`](http://svmiller.com/stevedata/reference/wvs_immig.html)                         | A data set on attitudes about immigration for all observations in the third to sixth wave of the World Values Survey. I use these data for in-class illustration.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [`wvs_justifbribe`](http://svmiller.com/stevedata/reference/wvs_justifbribe.html)             | A data set on attitudes about the justifiability of bribe-taking for all observations in the third to sixth wave of the World Values Survey. I use these data for in-class illustration about seemingly interval-level, but information-poor measurements.                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| [`wvs_usa_abortion`](http://svmiller.com/stevedata/reference/wvs_usa_abortion.html)           | A data set on attitudes about the justifiability of abortion in the United States based on World Values Survey responses recorded across six waves (from 1982 to 2011). I assembled this data frame probably around 2014 and routinely use it for in-class illustration about regression, post-estimation simulation, quantities of interest, and how to think about modeling a dependent variable that is on a 1-10 scale, but has curious heaping patterns.                                                                                                                                                                                                                              |
| [`yugo_sales`](http://svmiller.com/stevedata/reference/yugo_sales.html)                       | A data set on Yugo sales against two competing models in the United States from 1985 to 1992.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
