#' @importFrom tibble tibble
NULL

#' Norwegian Attitudes toward European Integration (2021-2022)
#'
#' This is a simple data set to illustrate the use of sampling weights from
#' the European Social Survey.
#'
#' @format A data frame with 1,411 observations on the following 24 variables.
#' \describe{
#' \item{\code{cntry}}{a character vector with Norway's two-character ISO code}
#' \item{\code{idno}}{a numeric identifier for the individual respondent}
#' \item{\code{region}}{a character for one of six regions recorded by the European Social Survey}
#' \item{\code{inwds}}{a date-time vector for the start of the interview}
#' \item{\code{inwde}}{a date-time vector for the end of the interview}
#' \item{\code{dweight}}{a design weight}
#' \item{\code{pspwght}}{a post-stratification weight, including the design weight}
#' \item{\code{pweight}}{a population size weight}
#' \item{\code{anweight}}{an analysis weight}
#' \item{\code{prob}}{the sampling probability}
#' \item{\code{stratum}}{the sampling stratum}
#' \item{\code{psu}}{the primary sampling unit}
#' \item{\code{eu_vote}}{a character vector indicating how a respondent would vote if given a vote on joining the European Union}
#' \item{\code{brnnorge}}{a dummy variable indicating whether respondent was born in Norway or not}
#' \item{\code{agea}}{a numeric vector for the respondent's age in years}
#' \item{\code{imbgeco}}{a numeric vector for if respondent thinks immigrants are generally good or bad for Norway's economy. Higher values = good}
#' \item{\code{imueclt}}{a numeric vector for if respondent thinks immigrants enrich or undermine Norway's culture. Higher values = enrich more than undermine}
#' \item{\code{imwbcnt}}{a numeric vector for if respondent thinks immigrants make Norway a better place to live. Higher values = better place to live}
#' \item{\code{female}}{a numeric vector for whether the respondent is a woman}
#' \item{\code{eduyrs}}{a numeric vector for total years of education for the respondent}
#' \item{\code{uempla}}{a numeric vector for whether the respondent is currently unemployed but seeking work}
#' \item{\code{polint}}{a dummy variable indicating political interest. 1 = very or quite interested. 0 = hardly or not at all interested.}
#' \item{\code{hinctnta}}{a numeric vector for household income in deciles}
#' \item{\code{lrscale}}{a numeric vector for the ideology of the respondent on an 11-point [0:10] scale}
#' }
#'
#' @details You'll want to convert the \code{eu_vote} variable into something usable.
#' Possible values include "Remain Outside", "Join EU", "Don't Know", "Not Eligible",
#' "Blank Ballot", "Refuse to Answer", "Wouldn't Vote". Perhaps it's reasonable
#' to make this a dummy variable comparing those who want to join versus those
#' who want Norway to remain outside the European Union.
#'
#' The data are edition 2.2 of the 10th round of European Social Survey, which
#' was released for public consumption on 21 December 2022.
#'
#' @source European Social Survey, Round 10
#'
"ESS10NO"
