% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{landsatVis}
\alias{landsatVis}
\title{Data visualization for landsat data}
\usage{
landsatVis(
  mat,
  img.nrow = 31,
  byrow = FALSE,
  colthm = rasterTheme(panel.background = list(col = "black"), region = brewer.pal(9,
    "YlOrRd")),
  ...
)
}
\arguments{
\item{mat}{A matrix, each row corresponds to a vectorized image pixel values.}

\item{img.nrow}{number of rows of the image}

\item{byrow}{logical value indicating whether the pixcel values are stored 
by row or by column. Default to FALSE}

\item{colthm}{Color theme for the plot, passing to the \code{par.settings} 
parameter of the \code{levelplot} function in the \code{rasterVis} package}

\item{...}{All other options passed to  \code{levelplot} function in the 
\code{rasterVis} package}
}
\description{
Data visualization for landsat data
}
\examples{
landsatVis(landsat106[landsat106$year == 2015, -c(1:2)], 
names.attr = as.character(landsat106$doy[landsat106$year == 2015]))
}
