% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelTopics.R
\name{labelTopics}
\alias{labelTopics}
\alias{print.labelTopics}
\title{Label topics}
\usage{
labelTopics(model, topics = NULL, n = 7, frexweight = 0.5)
}
\arguments{
\item{model}{An \code{STM} model object.}

\item{topics}{A vector of numbers indicating the topics to include.  Default
is all topics.}

\item{n}{The desired number of words (per type) used to label each topic.
Must be 1 or greater.}

\item{frexweight}{A weight used in our approximate FREX scoring algorithm
(see details).}
}
\value{
A labelTopics object (list) \item{prob }{matrix of highest
probability words} \item{frex }{matrix of highest ranking frex words}
\item{lift }{matrix of highest scoring words by lift} \item{score }{matrix
of best words by score} \item{topicnums }{a vector of topic numbers which
correspond to the rows}
}
\description{
Generate a set of words describing each topic from a fitted STM object.
Uses a variety of labeling algorithms (see details).
}
\details{
Four different types of word weightings are printed with label topics.

Highest Prob: are the words within each topic with the highest probability
(inferred directly from topic-word distribution parameter \eqn{\beta}).

FREX: are the words that are both frequent and exclusive, identifying words
that distinguish topics.  This is calculated by taking the harmonic mean of
rank by probability within the topic (frequency) and rank by distribution of
topic given word \eqn{p(z|w=v)} (exclusivity).  In estimating exclusivity we
use a James-Stein type shrinkage estimator of the distribution
\eqn{p(z|w=v)}.  More information can be found in the documentation for the
internal function \code{\link{calcfrex}} and \code{\link{js.estimate}}.

Score and Lift are measures provided in two other popular text mining
packages. For more information on type Score, see the R package
\code{\link{lda}} or the internal function \code{\link{calcscore}}.  
For more information on type Lift, see the R package \code{maptpx}
or or the internal function \code{\link{calclift}}.
}
\examples{
labelTopics(gadarianFit)
}
\seealso{
\code{\link{stm}} \code{\link{plot.STM}} 
\code{\link{calcfrex}} \code{\link{js.estimate}} \code{\link{calcscore}} \code{\link{calclift}}
}

